/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevesfactory.library.gui.RenderingHelper;

@OnlyIn(value=Dist.CLIENT)
public final class BackgroundRenderers {
    public static final int LIGHT_BORDER_COLOR = 0xFFFFFF;
    public static final int DARK_BORDER_COLOR = 0x606060;
    public static final int BACKGROUND_COLOR = 0xC6C6C6;
    private static final ResourceLocation TEXTURE = new ResourceLocation("sfm", "textures/gui/generic_components.png");
    private static final int UNIT_LENGTH = 4;
    private static final float UV_MULTIPLIER = 0.00390625f;
    private static float zLevel = 0.0f;

    private BackgroundRenderers() {
    }

    public static void drawFlatStyle(int x, int y, int width, int height, float z) {
        Preconditions.checkArgument((width >= 4 && height >= 4 ? 1 : 0) != 0);
        int x2 = x + width;
        int y2 = y + height;
        RenderingHelper.drawRect(x, y, x2, y2, 0xC6C6C6);
        RenderingHelper.usePlainColorGLStates();
        RenderingHelper.getRenderer().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderingHelper.rectVertices(x, y, x2, y2, 0x606060);
        RenderingHelper.rectVertices(x, y, x2 - 2, y2 - 2, 0xFFFFFF);
        RenderingHelper.rectVertices(x + 2, y + 2, x2 - 2, y2 - 2, 0xC6C6C6);
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
    }

    public static void drawVanillaStyle(int x, int y, int width, int height, float z) {
        Preconditions.checkArgument((width >= 8 && height >= 8 ? 1 : 0) != 0);
        RenderingHelper.useTextureGLStates();
        zLevel = z;
        RenderingHelper.getRenderer().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderingHelper.bindTexture(TEXTURE);
        int cornerXRight = x + width - 4;
        int cornerYBottom = y + height - 4;
        CornerPiece.drawTopLeft(x, y);
        CornerPiece.drawTopRight(cornerXRight, y);
        CornerPiece.drawBottomLeft(x, cornerYBottom);
        CornerPiece.drawBottomRight(cornerXRight, cornerYBottom);
        int bodyWidth = width - 8;
        int bodyHeight = height - 8;
        int bodyX = x + 4;
        int bodyY = y + 4;
        if (bodyWidth > 0) {
            EdgePiece.drawTop(bodyX, y, bodyWidth);
            EdgePiece.drawBottom(bodyX, bodyY + bodyHeight, bodyWidth);
        }
        if (bodyHeight > 0) {
            EdgePiece.drawLeft(x, bodyY, bodyHeight);
            EdgePiece.drawRight(bodyX + bodyWidth, bodyY, bodyHeight);
        }
        Tessellator.func_178181_a().func_78381_a();
        if (bodyWidth > 0 && bodyHeight > 0) {
            RenderingHelper.drawRect(bodyX, bodyY, bodyX + bodyWidth, bodyY + bodyHeight, 198, 198, 198, 255);
            RenderSystem.enableTexture();
        }
    }

    private static void plotVertexesTex(int x1, int y1, int width, int height, int tx, int ty) {
        int x2 = x1 + width;
        int y2 = y1 + height;
        int tx2 = tx + 4;
        int ty2 = ty + 4;
        float u1 = (float)tx * 0.00390625f;
        float u2 = (float)tx2 * 0.00390625f;
        float v1 = (float)ty * 0.00390625f;
        float v2 = (float)ty2 * 0.00390625f;
        RenderingHelper.getRenderer().func_225582_a_((double)x2, (double)y1, (double)zLevel).func_225583_a_(u2, v1).func_181675_d();
        RenderingHelper.getRenderer().func_225582_a_((double)x1, (double)y1, (double)zLevel).func_225583_a_(u1, v1).func_181675_d();
        RenderingHelper.getRenderer().func_225582_a_((double)x1, (double)y2, (double)zLevel).func_225583_a_(u1, v2).func_181675_d();
        RenderingHelper.getRenderer().func_225582_a_((double)x2, (double)y2, (double)zLevel).func_225583_a_(u2, v2).func_181675_d();
    }

    private static final class EdgePiece {
        private static final int TX_TOP = 16;
        private static final int TX_BOTTOM = 20;
        private static final int TX_LEFT = 24;
        private static final int TX_RIGHT = 28;
        private static final int TY = 0;

        private EdgePiece() {
        }

        private static void drawTop(int x, int y, int width) {
            BackgroundRenderers.plotVertexesTex(x, y, width, 4, 16, 0);
        }

        private static void drawBottom(int x, int y, int width) {
            BackgroundRenderers.plotVertexesTex(x, y, width, 4, 20, 0);
        }

        private static void drawLeft(int x, int y, int height) {
            BackgroundRenderers.plotVertexesTex(x, y, 4, height, 24, 0);
        }

        private static void drawRight(int x, int y, int height) {
            BackgroundRenderers.plotVertexesTex(x, y, 4, height, 28, 0);
        }
    }

    private static final class CornerPiece {
        private static final int TX_TOP_LEFT = 0;
        private static final int TX_TOP_RIGHT = 4;
        private static final int TX_BOTTOM_LEFT = 8;
        private static final int TX_BOTTOM_RIGHT = 12;
        private static final int TY = 0;

        private CornerPiece() {
        }

        private static void drawTopLeft(int x, int y) {
            BackgroundRenderers.plotVertexesTex(x, y, 4, 4, 0, 0);
        }

        private static void drawTopRight(int x, int y) {
            BackgroundRenderers.plotVertexesTex(x, y, 4, 4, 4, 0);
        }

        private static void drawBottomLeft(int x, int y) {
            BackgroundRenderers.plotVertexesTex(x, y, 4, 4, 8, 0);
        }

        private static void drawBottomRight(int x, int y) {
            BackgroundRenderers.plotVertexesTex(x, y, 4, 4, 12, 0);
        }
    }
}

