/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui;

import com.google.common.base.MoreObjects;
import java.awt.Dimension;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.library.gui.RenderingHelper;

public class TextureWrapper {
    public static final ResourceLocation INVALID_TEXTURE = RenderingHelper.linkTexture("textures/invalid");
    public static final TextureWrapper NONE = new TextureWrapper(INVALID_TEXTURE, 0, 0, 0, 0, 0, 0){

        @Override
        public void draw(int x, int y) {
        }

        @Override
        public void draw(int x, int y, int width, int height) {
        }
    };
    public static final ResourceLocation FLOW_COMPONENTS = RenderingHelper.linkTexture("gui/flow_components.png");
    private final ResourceLocation texture;
    private final int textureWidth;
    private final int textureHeight;
    private final int tx;
    private final int ty;
    private final int portionWidth;
    private final int portionHeight;

    public static TextureWrapper ofFlowComponent(int tx, int ty, int portionWidth, int portionHeight) {
        return new TextureWrapper(FLOW_COMPONENTS, 256, 256, tx, ty, portionWidth, portionHeight);
    }

    public static TextureWrapper ofGUITexture(String path, int textureWidth, int textureHeight, int tx, int ty, int portionWidth, int portionHeight) {
        return new TextureWrapper("textures/gui/" + path, textureWidth, textureHeight, tx, ty, portionWidth, portionHeight);
    }

    public TextureWrapper(String path, int textureWidth, int textureHeight, int tx, int ty, int portionWidth, int portionHeight) {
        this(new ResourceLocation("sfm", path), textureWidth, textureHeight, tx, ty, portionWidth, portionHeight);
    }

    public TextureWrapper(ResourceLocation texture, int textureWidth, int textureHeight, int tx, int ty, int portionWidth, int portionHeight) {
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.tx = tx;
        this.ty = ty;
        this.portionWidth = portionWidth;
        this.portionHeight = portionHeight;
    }

    public void draw(int x, int y) {
        this.draw(x, y, this.portionWidth, this.portionHeight);
    }

    public void draw(int x, int y, int width, int height) {
        RenderingHelper.bindTexture(this.texture);
        RenderingHelper.getRenderer().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.vertices(x, y, width, height);
        Tessellator.func_178181_a().func_78381_a();
    }

    public void vertices(int x, int y) {
        this.vertices(x, y, this.portionWidth, this.portionHeight);
    }

    public void vertices(int x, int y, int width, int height) {
        int x2 = x + width;
        int y2 = y + height;
        float uFactor = 1.0f / (float)this.textureWidth;
        float vFactor = 1.0f / (float)this.textureHeight;
        int tx2 = this.tx + this.portionWidth;
        int ty2 = this.ty + this.portionHeight;
        RenderingHelper.textureVertices(x, y, x2, y2, this.getZLevel(), (float)this.tx * uFactor, (float)this.ty * vFactor, (float)tx2 * uFactor, (float)ty2 * vFactor);
    }

    public Dimension getBounds() {
        return new Dimension(this.portionWidth, this.portionHeight);
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getTx() {
        return this.tx;
    }

    public int getTy() {
        return this.ty;
    }

    public float getZLevel() {
        return 0.0f;
    }

    public int getPortionWidth() {
        return this.portionWidth;
    }

    public int getPortionHeight() {
        return this.portionHeight;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("texture", (Object)this.texture).add("textureWidth", this.textureWidth).add("textureHeight", this.textureHeight).add("tx", this.tx).add("ty", this.ty).add("portionWidth", this.portionWidth).add("portionHeight", this.portionHeight).toString();
    }

    public String getName() {
        return this.texture.func_110623_a();
    }

    public TextureWrapper offset(int x, int y) {
        return new TextureWrapper(this.texture, this.textureWidth, this.textureHeight, this.tx + x, this.ty + y, this.portionWidth, this.portionHeight);
    }

    public TextureWrapper toDown(int times) {
        return this.down(this.portionHeight * times);
    }

    public TextureWrapper down(int y) {
        return this.offset(0, y);
    }

    public TextureWrapper toUp(int times) {
        return this.up(this.portionHeight * times);
    }

    public TextureWrapper up(int y) {
        return this.offset(0, -y);
    }

    public TextureWrapper toRight(int times) {
        return this.right(this.portionWidth * times);
    }

    public TextureWrapper right(int x) {
        return this.offset(x, 0);
    }

    public TextureWrapper toLeft(int times) {
        return this.left(this.portionWidth * times);
    }

    public TextureWrapper left(int x) {
        return this.offset(-x, 0);
    }

    public TextureWrapper withZ(float z) {
        return new TextureWrapperWithZ(this, z);
    }

    private static class TextureWrapperWithZ
    extends TextureWrapper {
        private float zLevel;

        public TextureWrapperWithZ(TextureWrapper source, float zLevel) {
            super(source.texture, source.textureWidth, source.textureHeight, source.tx, source.ty, source.portionWidth, source.portionHeight);
            this.zLevel = zLevel;
        }

        @Override
        public float getZLevel() {
            return this.zLevel;
        }
    }
}

