/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui;

import com.google.common.base.Preconditions;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.library.gui.RenderingHelper;

public final class ScissorTest {
    private static final int max = 100;
    private static ScissorTest[] objects = new ScissorTest[100];
    private static int lastObject = -1;
    private boolean destroyed = false;
    private int index;
    private int left;
    private int right;
    private int top;
    private int bottom;

    public static ScissorTest scaled(int x, int y, int width, int height) {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        double scale = mainWindow.func_198100_s();
        return new ScissorTest((int)((double)(x += RenderingHelper.getTranslationX()) * scale), (int)((double)mainWindow.func_198083_n() - (double)((y += RenderingHelper.getTranslationY()) + height) * scale), (int)((double)width * scale), (int)((double)height * scale));
    }

    public ScissorTest(int x, int y, int width, int height) {
        if (++lastObject < 100) {
            this.index = lastObject;
            ScissorTest.objects[this.index] = this;
            this.left = x;
            this.right = x + width - 1;
            this.top = y;
            this.bottom = y + height - 1;
            if (this.index > 0) {
                ScissorTest parent = objects[this.index - 1];
                if (this.left < parent.left) {
                    this.left = parent.left;
                }
                if (this.right > parent.right) {
                    this.right = parent.right;
                }
                if (this.top < parent.top) {
                    this.top = parent.top;
                }
                if (this.bottom > parent.bottom) {
                    this.bottom = parent.bottom;
                }
            }
            this.resume();
        } else {
            StevesFactoryManager.logger.error("Scissor count limit reached: 100");
        }
    }

    private void resume() {
        ScissorTest.scissor(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1);
        GL11.glEnable((int)3089);
    }

    public void destroy() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0);
        if (this.index < lastObject) {
            StevesFactoryManager.logger.error("There are scissors below this one");
        }
        GL11.glDisable((int)3089);
        ScissorTest.objects[this.index] = null;
        if (--lastObject > -1) {
            objects[lastObject].resume();
        }
        this.destroyed = true;
    }

    private static void scissor(int x, int y, int width, int height) {
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }
}

