/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.api.logic;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import vswe.stevesfactory.api.logic.IProcedure;

public final class Connection {
    private static final ImmutableList<Point> EMPTY_LIST = ImmutableList.of();
    private IProcedure from;
    private int fromIdx;
    private IProcedure to;
    private int toIdx;
    private int toIn;
    private List<Point> polylineNodes = EMPTY_LIST;

    public static Connection create(IProcedure from, int out, IProcedure to, int in) {
        Connection connection = new Connection(from, out, to, in);
        from.setOutputConnection(connection, out);
        to.setInputConnection(connection, in);
        return connection;
    }

    public static Connection createAndOverride(IProcedure from, int out, IProcedure to, int in) {
        Connection predecessor;
        Connection successor = from.successors()[out];
        if (successor != null) {
            successor.remove();
        }
        if ((predecessor = to.predecessors()[in]) != null) {
            predecessor.remove();
        }
        return Connection.create(from, out, to, in);
    }

    Connection(IProcedure from, int fromIdx, IProcedure to, int toIdx) {
        this.from = from;
        this.fromIdx = fromIdx;
        this.to = to;
        this.toIdx = toIdx;
    }

    public void remove() {
        this.from.removeOutputConnection(this.fromIdx);
        this.to.removeInputConnection(this.toIdx);
    }

    public IProcedure getSource() {
        return this.from;
    }

    public IProcedure getDestination() {
        return this.to;
    }

    public int getSourceOutputIndex() {
        return this.fromIdx;
    }

    public int getDestinationInputIndex() {
        return this.toIdx;
    }

    public void clearNodes() {
        if (this.polylineNodes != EMPTY_LIST) {
            this.polylineNodes.clear();
        }
    }

    private void updateListType() {
        if (this.polylineNodes == EMPTY_LIST) {
            this.polylineNodes = new ArrayList<Point>();
        }
    }

    public List<Point> getPolylineNodes() {
        this.updateListType();
        return this.polylineNodes;
    }

    long[] toPolylineData() {
        long[] data = new long[this.polylineNodes.size()];
        for (int i = 0; i < this.polylineNodes.size(); ++i) {
            Point point = this.polylineNodes.get(i);
            data[i] = (long)point.x << 32 | (long)point.y;
        }
        return data;
    }

    void fromPolylineData(long[] data) {
        this.updateListType();
        this.polylineNodes.clear();
        for (long pos : data) {
            this.polylineNodes.add(new Point((int)(pos >> 32), (int)pos));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("from", (Object)this.from).add("fromOut", this.fromIdx).add("to", (Object)this.to).add("toIn", this.toIdx).toString();
    }
}

