/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.MultiblockPositions;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.blakebr0.mysticalagriculture.tileentity.InfusionPedestalTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.ModTileEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class InfusionAltarTileEntity
extends BaseInventoryTileEntity
implements ITickableTileEntity {
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(2, () -> ((InfusionAltarTileEntity)this).markDirtyAndDispatch());
    private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(9);
    private final MultiblockPositions pedestalLocations = new MultiblockPositions.Builder().pos(3, 0, 0).pos(0, 0, 3).pos(-3, 0, 0).pos(0, 0, -3).pos(2, 0, 2).pos(2, 0, -2).pos(-2, 0, 2).pos(-2, 0, -2).build();
    private InfusionRecipe recipe;
    private int progress;
    private boolean active;

    public InfusionAltarTileEntity() {
        super((TileEntityType)ModTileEntities.INFUSION_ALTAR.get());
        this.inventory.setDefaultSlotLimit(1);
        this.inventory.setSlotValidator(this::canInsertStack);
        this.inventory.setOutputSlots(new int[]{1});
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74762_e("Progress");
        this.active = tag.func_74767_n("Active");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("Progress", this.progress);
        tag.func_74757_a("Active", this.active);
        return tag;
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world != null && !world.func_201670_d()) {
            ItemStack input = this.inventory.getStackInSlot(0);
            if (input.func_190926_b()) {
                this.reset();
                return;
            }
            if (this.isActive()) {
                List<InfusionPedestalTileEntity> pedestals = this.getPedestalsWithStuff();
                this.updateRecipeInventory(pedestals);
                if (this.recipe == null || !this.recipe.matches((IItemHandler)this.recipeInventory)) {
                    this.recipe = world.func_199532_z().func_215371_a(RecipeTypes.INFUSION, this.recipeInventory.toIInventory(), world).orElse(null);
                }
                if (this.recipe != null) {
                    ++this.progress;
                    if (this.progress >= 100) {
                        NonNullList remaining = this.recipe.getRemainingItems((IItemHandler)this.recipeInventory);
                        for (int i = 0; i < pedestals.size(); ++i) {
                            InfusionPedestalTileEntity pedestal2 = pedestals.get(i);
                            pedestal2.getInventory().setStackInSlot(0, (ItemStack)remaining.get(i + 1));
                            this.spawnParticles(ParticleTypes.field_197601_L, pedestal2.func_174877_v(), 1.2, 20);
                        }
                        this.setOutput(this.recipe.func_77571_b());
                        this.reset();
                        this.markDirtyAndDispatch();
                        this.spawnParticles(ParticleTypes.field_197632_y, this.func_174877_v(), 1.0, 10);
                    } else {
                        pedestals.forEach(pedestal -> {
                            BlockPos pos = pedestal.func_174877_v();
                            ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                            this.spawnItemParticles(pos, stack);
                        });
                    }
                } else {
                    this.reset();
                }
            } else {
                this.progress = 0;
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public List<BlockPos> getPedestalPositions() {
        return this.pedestalLocations.get(this.func_174877_v());
    }

    public boolean isActive() {
        if (!this.active) {
            World world = this.func_145831_w();
            this.active = world != null && world.func_175640_z(this.func_174877_v());
        }
        return this.active;
    }

    public void setActive() {
        this.active = true;
    }

    private void reset() {
        this.progress = 0;
        this.active = false;
    }

    private void updateRecipeInventory(List<InfusionPedestalTileEntity> pedestals) {
        this.recipeInventory.setSize(pedestals.size() + 1);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (int i = 0; i < pedestals.size(); ++i) {
            ItemStack stack = pedestals.get(i).getInventory().getStackInSlot(0);
            this.recipeInventory.setStackInSlot(i + 1, stack);
        }
    }

    private List<InfusionPedestalTileEntity> getPedestalsWithStuff() {
        if (this.func_145831_w() == null) {
            return new ArrayList<InfusionPedestalTileEntity>();
        }
        ArrayList<InfusionPedestalTileEntity> pedestals = new ArrayList<InfusionPedestalTileEntity>();
        this.getPedestalPositions().forEach(pos -> {
            InfusionPedestalTileEntity pedestal;
            ItemStack stack;
            TileEntity tile = this.func_145831_w().func_175625_s(pos);
            if (tile instanceof InfusionPedestalTileEntity && !(stack = (pedestal = (InfusionPedestalTileEntity)tile).getInventory().getStackInSlot(0)).func_190926_b()) {
                pedestals.add(pedestal);
            }
        });
        return pedestals;
    }

    private <T extends IParticleData> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)this.func_145831_w();
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + yOffset;
        double z = (double)pos.func_177952_p() + 0.5;
        world.func_195598_a(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        double x = (double)pedestalPos.func_177958_n() + world.func_201674_k().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.func_177956_o() + world.func_201674_k().nextDouble() * 0.2 + 1.2;
        double z = (double)pedestalPos.func_177952_p() + world.func_201674_k().nextDouble() * 0.2 + 0.4;
        double velX = pos.func_177958_n() - pedestalPos.func_177958_n();
        double velY = 0.25;
        double velZ = pos.func_177952_p() - pedestalPos.func_177952_p();
        world.func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private boolean canInsertStack(int slot, ItemStack stack) {
        return this.inventory.getStackInSlot(1).func_190926_b();
    }

    private void setOutput(ItemStack stack) {
        this.inventory.getStacks().set(0, (Object)ItemStack.field_190927_a);
        this.inventory.getStacks().set(1, (Object)stack);
    }
}

