/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.crop;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CropTier {
    public static final CropTier ELEMENTAL = new CropTier(new ResourceLocation("mysticalagriculture", "elemental"), 1, 7638528, TextFormatting.YELLOW);
    public static final CropTier ONE = new CropTier(new ResourceLocation("mysticalagriculture", "1"), 1, 7638528, TextFormatting.YELLOW);
    public static final CropTier TWO = new CropTier(new ResourceLocation("mysticalagriculture", "2"), 2, 35875, TextFormatting.GREEN);
    public static final CropTier THREE = new CropTier(new ResourceLocation("mysticalagriculture", "3"), 3, 12011776, TextFormatting.GOLD);
    public static final CropTier FOUR = new CropTier(new ResourceLocation("mysticalagriculture", "4"), 4, 32731, TextFormatting.AQUA);
    public static final CropTier FIVE = new CropTier(new ResourceLocation("mysticalagriculture", "5"), 5, 0xC40000, TextFormatting.RED);
    private final ResourceLocation id;
    private final int value;
    private final int color;
    private final TextFormatting textColor;
    private Supplier<? extends FarmlandBlock> farmland;
    private Supplier<? extends Item> essence;
    private ITextComponent displayName;
    private boolean fertilizable;
    private boolean secondarySeedDrop;

    public CropTier(ResourceLocation id, int value, int color, TextFormatting textColor) {
        this.id = id;
        this.value = value;
        this.color = color;
        this.textColor = textColor;
        this.fertilizable = true;
        this.secondarySeedDrop = true;
        MysticalAgricultureAPI.CROP_TIERS.add(this);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.id.func_110623_a();
    }

    public int getValue() {
        return this.value;
    }

    public int getColor() {
        return this.color;
    }

    public TextFormatting getTextColor() {
        return this.textColor;
    }

    public String getModId() {
        return this.id.func_110624_b();
    }

    public FarmlandBlock getFarmland() {
        return this.farmland == null ? null : this.farmland.get();
    }

    public CropTier setFarmland(Supplier<? extends FarmlandBlock> farmland) {
        this.farmland = farmland;
        return this;
    }

    public Item getEssence() {
        return this.essence == null ? null : this.essence.get();
    }

    public CropTier setEssence(Supplier<? extends Item> essence) {
        this.essence = essence;
        return this;
    }

    public boolean isEffectiveFarmland(Block block) {
        return this.farmland.get() == block;
    }

    public ITextComponent getDisplayName() {
        if (this.displayName != null) {
            return this.displayName.func_211708_a(this.getTextColor());
        }
        return new TranslationTextComponent(String.format("cropTier.%s.%s", this.getModId(), this.getName()), new Object[0]).func_211708_a(this.getTextColor());
    }

    public CropTier setDisplayName(ITextComponent name) {
        this.displayName = name;
        return this;
    }

    public boolean isFertilizable() {
        return this.fertilizable;
    }

    public CropTier setFertilizable(boolean fertilizable) {
        this.fertilizable = fertilizable;
        return this;
    }

    public boolean hasSecondarySeedDrop() {
        return this.secondarySeedDrop;
    }

    public CropTier setSecondarySeedDrop(boolean secondarySeedDrop) {
        this.secondarySeedDrop = secondarySeedDrop;
        return this;
    }
}

