/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandWarp {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"warp").requires(source -> source.func_197034_c(0));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandWarp.warp((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"warpName", (ArgumentType)StringArgumentType.string()).suggests(Methods.WARP_SUGGEST).executes(context -> CommandWarp.warpArgs((CommandContext<CommandSource>)context)));
        dispatcher.register(builder);
        LiteralArgumentBuilder builder2 = (LiteralArgumentBuilder)Commands.func_197057_a((String)"warps").requires(source -> source.func_197034_c(0));
        builder2.executes(context -> CommandWarp.warp((CommandContext<CommandSource>)context));
        dispatcher.register(builder2);
    }

    private static int warp(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        Set<String> warps = DataManager.getWarp().getWarps().keySet();
        TextComponent warpList = Methods.formatText("warp.maessentials.list", warps.size());
        if (warps.size() != 0) {
            int i = 1;
            for (String name : warps) {
                ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/warp " + name);
                HoverEvent eventHover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)Methods.formatText("warp.maessentials.list.warp", "/warp " + name));
                TextComponent kit = Methods.formatText("warp.maessentials.list.warp", name);
                kit.func_150256_b().func_150241_a(clickEvent);
                kit.func_150256_b().func_150209_a(eventHover);
                warpList.func_150257_a((ITextComponent)kit);
                if (warps.size() == i) continue;
                warpList.func_150257_a((ITextComponent)new StringTextComponent(", "));
                ++i;
            }
        } else {
            warpList.func_150257_a((ITextComponent)new StringTextComponent("-"));
        }
        player.func_145747_a((ITextComponent)warpList);
        return 1;
    }

    private static int warpArgs(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        String warpName = StringArgumentType.getString(context, (String)"warpName").toLowerCase();
        CommandWarp.doWarp(player, warpName);
        return 1;
    }

    private static void doWarp(ServerPlayerEntity player, String name) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        Location location = DataManager.getWarp().getWarp(name);
        if (location == null) {
            player.func_145747_a((ITextComponent)Methods.formatText("warp.maessentials.not_exist", name));
            return;
        }
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("warp", ConfigValues.warps_cooldown.intValue());
        if (cooldown != 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.cooldown.teleport", cooldown));
            return;
        }
        eslPlayer.getUsage().setCommandUsage("warp");
        eslPlayer.saveData();
        if (Methods.simpleTeleport(player, location, "warp", ConfigValues.warps_delay.intValue())) {
            if (ConfigValues.warps_delay == 0) {
                player.func_145747_a((ITextComponent)Methods.formatText("warp.maessentials.success", name));
            } else {
                player.func_145747_a((ITextComponent)Methods.formatText("warp.maessentials.success.wait", name, ConfigValues.warps_delay));
            }
        }
    }
}

