/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class CommandHome {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"home").requires(source -> source.func_197034_c(0));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandHome.home((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"homeName", (ArgumentType)StringArgumentType.string()).suggests(Methods.HOME_SUGGEST).executes(context -> CommandHome.homeArgs((CommandContext<CommandSource>)context)));
        dispatcher.register(builder);
    }

    private static int home(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        CommandHome.doHome(player, "home");
        return 1;
    }

    private static int homeArgs(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        String homeName = StringArgumentType.getString(context, (String)"homeName").toLowerCase();
        CommandHome.doHome(player, homeName);
        return 1;
    }

    private static void doHome(ServerPlayerEntity player, String name) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (eslPlayer.getHomeData().getHomes().size() == 0) {
            player.func_145747_a((ITextComponent)Methods.formatText("home.maessentials.no_homes", new Object[0]));
            return;
        }
        Location location = eslPlayer.getHomeData().getHome(name);
        if (location == null) {
            player.func_145747_a((ITextComponent)Methods.formatText("home.maessentials.not_exist", name));
            return;
        }
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("home", ConfigValues.homes_cooldown.intValue());
        if (cooldown != 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.cooldown.teleport", cooldown));
            return;
        }
        eslPlayer.getUsage().setCommandUsage("home");
        eslPlayer.saveData();
        if (Methods.simpleTeleport(player, location, "home", ConfigValues.homes_delay.intValue())) {
            if (ConfigValues.homes_delay == 0) {
                player.func_145747_a((ITextComponent)Methods.formatText("home.maessentials.teleport", name));
            } else {
                player.func_145747_a((ITextComponent)Methods.formatText("home.maessentials.teleport.wait", name, ConfigValues.homes_delay));
            }
        }
    }
}

