/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;

public class CommandGm {
    private static final SuggestionProvider<CommandSource> GM_SUGGEST = (context, builder) -> {
        String[] gm = new String[]{"0", "1", "2", "3"};
        return ISuggestionProvider.func_197008_a((String[])gm, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"gm").requires(source -> source.func_197034_c(2));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandGm.gm((CommandContext<CommandSource>)context))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"gamemode", (ArgumentType)IntegerArgumentType.integer()).suggests(GM_SUGGEST).executes(context -> CommandGm.gmSelf((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> CommandGm.gmOthers((CommandContext<CommandSource>)context))));
        dispatcher.register(builder);
    }

    private static int gm(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)Methods.formatText("maessentials.provide.player", new Object[0]));
        return 1;
    }

    private static int gmSelf(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        int gamemode = IntegerArgumentType.getInteger(context, (String)"gamemode");
        CommandGm.gmManage(player, player, gamemode);
        return 1;
    }

    private static int gmOthers(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity targetPlayer = EntityArgument.func_197089_d(context, (String)"targetPlayer");
        int gamemode = IntegerArgumentType.getInteger(context, (String)"gamemode");
        CommandGm.gmManage(player, targetPlayer, gamemode);
        return 1;
    }

    private static void gmManage(ServerPlayerEntity player, ServerPlayerEntity targetPlayer, int gm) {
        boolean changed = false;
        switch (gm) {
            case 0: {
                if (targetPlayer.field_71134_c.func_73081_b() == GameType.SURVIVAL) break;
                targetPlayer.func_71033_a(GameType.SURVIVAL);
                changed = true;
                break;
            }
            case 1: {
                if (targetPlayer.field_71134_c.func_73081_b() == GameType.CREATIVE) break;
                targetPlayer.func_71033_a(GameType.CREATIVE);
                changed = true;
                break;
            }
            case 2: {
                if (targetPlayer.field_71134_c.func_73081_b() == GameType.ADVENTURE) break;
                targetPlayer.func_71033_a(GameType.ADVENTURE);
                changed = true;
                break;
            }
            case 3: {
                if (targetPlayer.field_71134_c.func_73081_b() == GameType.SPECTATOR) break;
                targetPlayer.func_71033_a(GameType.SPECTATOR);
                changed = true;
                break;
            }
            default: {
                player.func_145747_a((ITextComponent)Methods.formatText("gm.maessentials.invalid", new Object[0]));
            }
        }
        if (changed) {
            ITextComponent newGm = targetPlayer.field_71134_c.func_73081_b().func_196220_c();
            if (player == targetPlayer) {
                player.func_145747_a((ITextComponent)Methods.formatText("gm.maessentials.self", newGm));
            } else {
                player.func_145747_a((ITextComponent)Methods.formatText("gm.maessentials.player", targetPlayer.func_145748_c_(), newGm));
                targetPlayer.func_145747_a((ITextComponent)Methods.formatText("gm.maessentials.self", newGm));
            }
        }
    }
}

