/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public final class SidedExecutor {
    @Nullable
    public static <T> T callOnSide(LogicalSide side, Supplier<Callable<T>> toRun) {
        return side.isClient() ? SidedExecutor.callForSide(toRun, null) : SidedExecutor.callForSide(null, toRun);
    }

    @Nullable
    public static <T> T callForSide(@Nullable Supplier<Callable<T>> client, @Nullable Supplier<Callable<T>> server) {
        try {
            if (EffectiveSide.get().isClient() && client != null) {
                return client.get().call();
            }
            if (server != null) {
                return server.get().call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void runOnSide(LogicalSide side, Supplier<Runnable> toRun) {
        if (side.isClient()) {
            SidedExecutor.runForSide(toRun, null);
        } else {
            SidedExecutor.runForSide(null, toRun);
        }
    }

    public static void runForSide(@Nullable Supplier<Runnable> client, @Nullable Supplier<Runnable> server) {
        try {
            if (EffectiveSide.get().isClient() && client != null) {
                client.get().run();
            } else if (server != null) {
                server.get().run();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

