/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class CheckStructure
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final String structureName;
    private Structure<?> structure;

    public CheckStructure(String structureName) {
        this.structureName = structureName;
    }

    public boolean test(LootContext ctx) {
        BlockPos pos = (BlockPos)ctx.func_216031_c(LootParameters.field_216286_f);
        if (pos != null && this.loadStructure()) {
            return this.structure.func_202366_b((IWorld)ctx.func_202879_g(), pos);
        }
        return false;
    }

    private boolean loadStructure() {
        if (this.structure == null) {
            this.structure = (Structure)Feature.field_202300_at.get((Object)this.structureName);
            if (this.structure == null) {
                Bookshelf.LOG.error("Loot table condition is looking for structure {} which doesn't exist.", (Object)this.structureName);
                return false;
            }
        }
        return true;
    }

    static class Serializer
    extends ILootCondition.AbstractSerializer<CheckStructure> {
        Serializer() {
            super(new ResourceLocation("bookshelf", "check_structure"), CheckStructure.class);
        }

        public void serialize(JsonObject json, CheckStructure value, JsonSerializationContext context) {
            json.addProperty("structure", value.structureName);
        }

        public CheckStructure deserialize(JsonObject json, JsonDeserializationContext context) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"structure");
            return new CheckStructure(name);
        }
    }
}

