/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.gui.forbiddenmicon.element.button;

import com.stal111.forbidden_arcanus.gui.element.button.ButtonElement;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconScreen;
import java.util.Collections;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.text.TranslationTextComponent;

public class ChangeFurnaceTypeButton
extends ButtonElement {
    private final FurnaceType furnaceType;

    public ChangeFurnaceTypeButton(int posX, int posY, int blitOffset, FurnaceType furnaceType, ButtonElement.IPressable onPress) {
        super(posX, posY, blitOffset, 417, 161, 14, 15, ForbiddenmiconScreen.FORBIDDENMICON_GUI_TEXTURES, onPress);
        this.furnaceType = furnaceType;
    }

    @Override
    public String getName() {
        return "change_furnace_type_button";
    }

    @Override
    public void render(int x, int y) {
        int i = this.getStartX() + (this.furnaceType == FurnaceType.SMOKER ? -16 : (this.furnaceType == FurnaceType.BLAST_FURNACE ? 16 : 0));
        this.bindTexture(ForbiddenmiconScreen.FORBIDDENMICON_GUI_TEXTURES);
        this.blit(this.getBlitOffset(), i, this.isActivated() ? this.getStartY() - 16 : this.getStartY(), 14, 15, 256, 512);
    }

    @Override
    public void renderHoverEffect(int x, int y) {
        if (x >= this.getPosX() && y >= this.getPosY() && x < this.getPosX() + this.getSizeX() && y < this.getPosY() + this.getSizeY()) {
            this.renderFancyTooltip(Collections.singletonList(new TranslationTextComponent("forbiddenmicon.recipe.smelting." + this.getFurnaceType().toString().toLowerCase(), new Object[0]).func_150254_d()), x, y);
        }
    }

    public FurnaceType getFurnaceType() {
        return this.furnaceType;
    }

    public static enum FurnaceType {
        FURNACE((IRecipeSerializer<?>)IRecipeSerializer.field_222171_o, (IRecipeType<?>)IRecipeType.field_222150_b),
        SMOKER((IRecipeSerializer<?>)IRecipeSerializer.field_222173_q, (IRecipeType<?>)IRecipeType.field_222152_d),
        BLAST_FURNACE((IRecipeSerializer<?>)IRecipeSerializer.field_222172_p, (IRecipeType<?>)IRecipeType.field_222151_c);

        private final IRecipeSerializer<?> recipeSerializer;
        private final IRecipeType<AbstractCookingRecipe> recipeType;

        private FurnaceType(IRecipeSerializer<?> recipeSerializer, IRecipeType<?> recipeType) {
            this.recipeSerializer = recipeSerializer;
            this.recipeType = recipeType;
        }

        public IRecipeSerializer<?> getRecipeSerializer() {
            return this.recipeSerializer;
        }

        public IRecipeType<AbstractCookingRecipe> getRecipeType() {
            return this.recipeType;
        }
    }
}

