/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.tiles.ITilePacketBuffer;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.AbstractPacket;

public class TilePacketBufferPacket
extends AbstractPacket {
    public ITilePacketBuffer tile;
    public BlockPos pos;
    public byte id;
    public ByteBuf buf;

    public TilePacketBufferPacket(PacketBuffer buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.id = buf.readByte();
        this.buf = buf.retain();
    }

    public TilePacketBufferPacket(ITilePacketBuffer tile, BlockPos pos, byte id) {
        this.tile = tile;
        this.pos = pos;
        this.id = id;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeByte((int)this.id);
        this.tile.writePacket(buf, this.id);
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        TileEntity tile;
        PlayerEntity player = PacketHandler.getPlayer(ctx);
        if (player != null && (tile = player.func_130014_f_().func_175625_s(this.pos)) instanceof ITilePacketBuffer) {
            ((ITilePacketBuffer)tile).readPacket(new PacketBuffer(this.buf), this.id);
            this.buf.release();
        }
        return null;
    }
}

