/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.network.EnumAccessType;
import sonar.fluxnetworks.api.network.EnumSecurityType;
import sonar.fluxnetworks.api.network.FluxCacheTypes;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.data.FluxNetworkData;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.FeedbackPacket;
import sonar.fluxnetworks.common.network.NetworkColourPacket;
import sonar.fluxnetworks.common.network.NetworkUpdatePacket;

public class GeneralPacketHandler {
    public static CompoundNBT getCreateNetworkPacket(String name, int color, EnumSecurityType security, EnergyType energy, String password) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, name);
        tag.func_74768_a(FluxNetworkData.NETWORK_COLOR, color);
        tag.func_74768_a(FluxNetworkData.SECURITY_TYPE, security.ordinal());
        tag.func_74768_a(FluxNetworkData.ENERGY_TYPE, energy.ordinal());
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static Object handleCreateNetworkPacket(PlayerEntity player, CompoundNBT nbtTag) {
        String name = nbtTag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        int color = nbtTag.func_74762_e(FluxNetworkData.NETWORK_COLOR);
        EnumSecurityType security = EnumSecurityType.values()[nbtTag.func_74762_e(FluxNetworkData.SECURITY_TYPE)];
        EnergyType energy = EnergyType.values()[nbtTag.func_74762_e(FluxNetworkData.ENERGY_TYPE)];
        String password = nbtTag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (!FluxUtils.checkPassword(password)) {
            return new FeedbackPacket(EnumFeedbackInfo.ILLEGAL_PASSWORD);
        }
        if (FluxNetworkCache.instance.hasSpaceLeft(player)) {
            FluxNetworkCache.instance.createdNetwork(player, name, color, security, energy, password);
            return new FeedbackPacket(EnumFeedbackInfo.SUCCESS);
        }
        return new FeedbackPacket(EnumFeedbackInfo.NO_SPACE);
    }

    public static CompoundNBT getNetworkEditPacket(int networkID, String networkName, int color, EnumSecurityType security, EnergyType energy, String password) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, networkName);
        tag.func_74768_a(FluxNetworkData.NETWORK_COLOR, color);
        tag.func_74768_a(FluxNetworkData.SECURITY_TYPE, security.ordinal());
        tag.func_74768_a(FluxNetworkData.ENERGY_TYPE, energy.ordinal());
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static Object handleNetworkEditPacket(PlayerEntity player, CompoundNBT tag) {
        int networkID = tag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String newName = tag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        int color = tag.func_74762_e(FluxNetworkData.NETWORK_COLOR);
        EnumSecurityType security = EnumSecurityType.values()[tag.func_74762_e(FluxNetworkData.SECURITY_TYPE)];
        EnergyType energy = EnergyType.values()[tag.func_74762_e(FluxNetworkData.ENERGY_TYPE)];
        String password = tag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (!FluxUtils.checkPassword(password)) {
            return new FeedbackPacket(EnumFeedbackInfo.ILLEGAL_PASSWORD);
        }
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                boolean needPacket = false;
                if (!network.getSetting(NetworkSettings.NETWORK_NAME).equals(newName)) {
                    network.setSetting(NetworkSettings.NETWORK_NAME, newName);
                    needPacket = true;
                }
                if (network.getSetting(NetworkSettings.NETWORK_COLOR) != color) {
                    network.setSetting(NetworkSettings.NETWORK_COLOR, color);
                    needPacket = true;
                    List<IFluxConnector> list = network.getConnections(FluxCacheTypes.flux);
                    list.forEach(fluxConnector -> fluxConnector.connect(network));
                }
                if (needPacket) {
                    HashMap<Integer, Tuple<Integer, String>> cache = new HashMap<Integer, Tuple<Integer, String>>();
                    cache.put(networkID, new Tuple((Object)(network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000), (Object)network.getSetting(NetworkSettings.NETWORK_NAME)));
                    PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new NetworkColourPacket(cache));
                }
                network.setSetting(NetworkSettings.NETWORK_SECURITY, security);
                network.setSetting(NetworkSettings.NETWORK_ENERGY, energy);
                network.setSetting(NetworkSettings.NETWORK_PASSWORD, password);
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL));
                return new FeedbackPacket(EnumFeedbackInfo.SUCCESS_2);
            }
            return new FeedbackPacket(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static CompoundNBT getDeleteNetworkPacket(int networkID) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        return tag;
    }

    public static Object handleDeleteNetworkPacket(PlayerEntity player, CompoundNBT nbtTag) {
        int id = nbtTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        IFluxNetwork toDelete = FluxNetworkCache.instance.getNetwork(id);
        if (!toDelete.isInvalid()) {
            if (toDelete.getMemberPermission(player).canDelete()) {
                FluxNetworkData.get().removeNetwork(toDelete);
                return new FeedbackPacket(EnumFeedbackInfo.SUCCESS);
            }
            return new FeedbackPacket(EnumFeedbackInfo.NO_OWNER);
        }
        return null;
    }

    @Deprecated
    public static CompoundNBT getAddMemberPacket(int networkID, String playerName) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a("playerName", playerName);
        return tag;
    }

    @Deprecated
    public static Object handleAddMemberPacket(PlayerEntity player, CompoundNBT packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String playerName = packetTag.func_74779_i("playerName");
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.addNewMember(playerName);
                return new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
            }
            return new FeedbackPacket(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    @Deprecated
    public static CompoundNBT getRemoveMemberPacket(int networkID, UUID playerRemoved) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_186854_a("playerRemoved", playerRemoved);
        return tag;
    }

    @Deprecated
    public static Object handleRemoveMemberPacket(PlayerEntity player, CompoundNBT packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        UUID playerRemoved = packetTag.func_186857_a("playerRemoved");
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.removeMember(playerRemoved);
                return new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
            }
            return new FeedbackPacket(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static CompoundNBT getChangePermissionPacket(int networkID, UUID playerChanged, int type) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_186854_a("playerChanged", playerChanged);
        tag.func_74768_a("t", type);
        return tag;
    }

    public static Object handleChangePermissionPacket(PlayerEntity player, CompoundNBT packetTag) {
        IFluxNetwork network;
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        UUID playerChanged = packetTag.func_186857_a("playerChanged");
        int type = packetTag.func_74762_e("t");
        if (playerChanged != null && !(network = FluxNetworkCache.instance.getNetwork(networkID)).isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                if (type == 0) {
                    ServerPlayerEntity player1 = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(playerChanged);
                    if (player1 != null) {
                        NetworkMember newMember = NetworkMember.createNetworkMember((PlayerEntity)player1, EnumAccessType.USER);
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(newMember);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new FeedbackPacket(EnumFeedbackInfo.SUCCESS));
                        return new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
                    }
                    return new FeedbackPacket(EnumFeedbackInfo.INVALID_USER);
                }
                Optional<NetworkMember> settings = network.getValidMember(playerChanged);
                if (settings.isPresent()) {
                    NetworkMember p = settings.get();
                    if (type == 1) {
                        p.setAccessPermission(EnumAccessType.ADMIN);
                    } else if (type == 2) {
                        p.setAccessPermission(EnumAccessType.USER);
                    } else if (type == 3) {
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).remove(p);
                    } else if (type == 4) {
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).removeIf(f -> f.getAccessPermission().canDelete());
                        network.setSetting(NetworkSettings.NETWORK_OWNER, playerChanged);
                        p.setAccessPermission(EnumAccessType.OWNER);
                    }
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new FeedbackPacket(EnumFeedbackInfo.SUCCESS));
                    return new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
                }
                if (type == 4) {
                    ServerPlayerEntity player1 = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(playerChanged);
                    if (player1 != null) {
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).removeIf(f -> f.getAccessPermission().canDelete());
                        NetworkMember newMember = NetworkMember.createNetworkMember((PlayerEntity)player1, EnumAccessType.OWNER);
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(newMember);
                        network.setSetting(NetworkSettings.NETWORK_OWNER, playerChanged);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new FeedbackPacket(EnumFeedbackInfo.SUCCESS));
                        return new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
                    }
                    return new FeedbackPacket(EnumFeedbackInfo.INVALID_USER);
                }
                return new FeedbackPacket(EnumFeedbackInfo.INVALID_USER);
            }
            return new FeedbackPacket(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static CompoundNBT getChangeWirelessPacket(int networkID, int wirelessMode) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74768_a(FluxNetworkData.WIRELESS_MODE, wirelessMode);
        return tag;
    }

    public static Object handleChangeWirelessPacket(PlayerEntity player, CompoundNBT packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        int wireless = packetTag.func_74762_e(FluxNetworkData.WIRELESS_MODE);
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.setSetting(NetworkSettings.NETWORK_WIRELESS, wireless);
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL));
                return new FeedbackPacket(EnumFeedbackInfo.SUCCESS);
            }
            return new FeedbackPacket(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }
}

