/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.client.FluxColorHandler;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.data.FluxNetworkData;

public class FluxConnectorBlockItem
extends BlockItem {
    public static String CUSTOM_NAME = "customName";
    public static String PRIORITY = "priority";
    public static String SURGE_MODE = "surgeMode";
    public static String LIMIT = "limit";
    public static String DISABLE_LIMIT = "disableLimit";

    public FluxConnectorBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("FluxData");
        if (tag != null && tag.func_74764_b(CUSTOM_NAME)) {
            return new StringTextComponent(tag.func_74779_i(CUSTOM_NAME));
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_179543_a("FluxData");
        if (tag != null) {
            if (tag.func_74764_b(FluxNetworkData.NETWORK_ID)) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.NETWORK_FULL_NAME.t() + ": " + TextFormatting.RESET + FluxColorHandler.getOrRequestNetworkName(tag.func_74762_e(FluxNetworkData.NETWORK_ID))));
            }
            if (tag.func_74764_b(LIMIT)) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.RESET + FluxUtils.format(tag.func_74763_f(LIMIT), FluxUtils.TypeNumberFormat.COMMAS, " " + EnergyType.FE.getStorageSuffix())));
            }
            if (tag.func_74764_b(PRIORITY)) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.PRIORITY.t() + ": " + TextFormatting.RESET + tag.func_74762_e(PRIORITY)));
            }
            if (tag.func_74764_b("energy")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.RESET + NumberFormat.getInstance().format(tag.func_74762_e("energy")) + " " + EnergyType.FE.getStorageSuffix()));
            }
            if (tag.func_74764_b("buffer")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.RESET + FluxUtils.format(tag.func_74763_f("buffer"), FluxUtils.TypeNumberFormat.COMMAS, EnergyType.FE.getStorageSuffix())));
            }
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }
}

