/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.handler;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.common.handler.ItemEnergyHandler;
import sonar.fluxnetworks.common.handler.energy.FNEnergyHandler;
import sonar.fluxnetworks.common.handler.energy.ForgeEnergyHandler;

public class TileEntityHandler {
    public static List<ITileEnergyHandler> tileEnergyHandlers = Lists.newArrayList();
    public static Map<String, Integer> blockBlacklist = new HashMap<String, Integer>();

    public static void registerEnergyHandler() {
        tileEnergyHandlers.add(FNEnergyHandler.INSTANCE);
        ItemEnergyHandler.itemEnergyHandlers.add(FNEnergyHandler.INSTANCE);
        tileEnergyHandlers.add(ForgeEnergyHandler.INSTANCE);
        ItemEnergyHandler.itemEnergyHandlers.add(ForgeEnergyHandler.INSTANCE);
    }

    @Nullable
    public static ITileEnergyHandler getEnergyHandler(TileEntity tile, Direction dir) {
        if (tile instanceof IFluxConnector) {
            return null;
        }
        ResourceLocation registryName = tile.func_195044_w().func_177230_c().getRegistryName();
        if (registryName != null && blockBlacklist.containsKey(registryName.toString())) {
            return null;
        }
        for (ITileEnergyHandler handler : tileEnergyHandlers) {
            if (!handler.canRenderConnection(tile, dir)) continue;
            return handler;
        }
        return null;
    }

    public static boolean canRenderConnection(TileEntity tile, Direction dir) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IFluxConnector) {
            return false;
        }
        ResourceLocation registryName = tile.func_195044_w().func_177230_c().getRegistryName();
        if (registryName != null && blockBlacklist.containsKey(registryName.toString())) {
            return false;
        }
        ITileEnergyHandler handler = null;
        for (ITileEnergyHandler handler1 : tileEnergyHandlers) {
            if (!handler1.canRenderConnection(tile, dir)) continue;
            handler = handler1;
        }
        return handler != null;
    }
}

