/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.data;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.EnumAccessType;
import sonar.fluxnetworks.api.network.EnumSecurityType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.ISuperAdmin;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.utils.Capabilities;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxLiteConnector;
import sonar.fluxnetworks.common.connection.FluxNetworkBase;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.connection.FluxNetworkServer;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.NetworkUpdatePacket;

public class FluxNetworkData
extends WorldSavedData {
    private static final String NETWORK_DATA = "fluxnetworksdata";
    private static FluxNetworkData data;
    public static String NETWORKS;
    public static String LOADED_CHUNKS;
    public static String UNIQUE_ID;
    public static String NETWORK_ID;
    public static String NETWORK_NAME;
    public static String NETWORK_COLOR;
    public static String NETWORK_PASSWORD;
    public static String SECURITY_TYPE;
    public static String ENERGY_TYPE;
    public static String OWNER_UUID;
    public static String WIRELESS_MODE;
    public static String PLAYER_LIST;
    public static String NETWORK_FOLDERS;
    public static String UNLOADED_CONNECTIONS;
    public static String OLD_NETWORK_ID;
    public static String OLD_NETWORK_NAME;
    public static String OLD_NETWORK_COLOR;
    public static String OLD_NETWORK_ACCESS;
    public Map<Integer, IFluxNetwork> networks = new HashMap<Integer, IFluxNetwork>();
    public Map<Integer, List<ChunkPos>> loadedChunks = new HashMap<Integer, List<ChunkPos>>();
    public int uniqueID = 1;

    public FluxNetworkData() {
        super(NETWORK_DATA);
    }

    public static void clear() {
        if (data != null) {
            data = null;
            FluxNetworks.LOGGER.info("FluxNetworkData has been unloaded");
        }
    }

    public boolean func_76188_b() {
        return true;
    }

    public static FluxNetworkData get() {
        if (data == null) {
            data = FluxNetworkData.loadData();
        }
        return data;
    }

    private static FluxNetworkData loadData() {
        ServerWorld saveWorld = DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)DimensionType.field_223227_a_, (boolean)false, (boolean)false);
        FluxNetworkData data = (FluxNetworkData)saveWorld.func_217481_x().func_215752_a(FluxNetworkData::new, NETWORK_DATA);
        FluxNetworks.LOGGER.info("FluxNetworkData has been successfully loaded");
        return data;
    }

    public void addNetwork(IFluxNetwork network) {
        this.networks.putIfAbsent(network.getNetworkID(), network);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL));
    }

    public void removeNetwork(IFluxNetwork network) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_CLEAR));
        network.onRemoved();
        this.networks.remove(network.getNetworkID());
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.uniqueID = nbt.func_74762_e(UNIQUE_ID);
        if (nbt.func_74764_b(NETWORKS)) {
            ListNBT list = nbt.func_150295_c(NETWORKS, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                FluxNetworkServer network = new FluxNetworkServer();
                if (tag.func_74764_b(OLD_NETWORK_ID)) {
                    FluxNetworkData.readOldData(network, tag);
                } else {
                    network.readNetworkNBT(tag, NBTType.ALL_SAVE);
                }
                this.addNetwork(network);
            }
        }
        this.readChunks(nbt);
        data = this;
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a(UNIQUE_ID, this.uniqueID);
        ListNBT list = new ListNBT();
        for (IFluxNetwork network : FluxNetworkCache.instance.getAllNetworks()) {
            CompoundNBT tag = new CompoundNBT();
            network.writeNetworkNBT(tag, NBTType.ALL_SAVE);
            list.add((Object)tag);
        }
        compound.func_218657_a(NETWORKS, (INBT)list);
        CompoundNBT tag = new CompoundNBT();
        this.loadedChunks.forEach((dim, pos) -> this.writeChunks((int)dim, (List<ChunkPos>)pos, tag));
        compound.func_218657_a(LOADED_CHUNKS, (INBT)tag);
        return compound;
    }

    public static void readPlayers(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        if (!nbt.func_74764_b(PLAYER_LIST)) {
            return;
        }
        ArrayList<NetworkMember> a = new ArrayList<NetworkMember>();
        ListNBT list = nbt.func_150295_c(PLAYER_LIST, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT c = list.func_150305_b(i);
            a.add(new NetworkMember(c));
        }
        network.setSetting(NetworkSettings.NETWORK_PLAYERS, a);
    }

    public static CompoundNBT writePlayers(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List<NetworkMember> a = network.getSetting(NetworkSettings.NETWORK_PLAYERS);
        if (!a.isEmpty()) {
            ListNBT list = new ListNBT();
            a.forEach(s -> list.add((Object)s.writeNetworkNBT(new CompoundNBT())));
            nbt.func_218657_a(PLAYER_LIST, (INBT)list);
        }
        return nbt;
    }

    public static void writeAllPlayers(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List players;
        List<NetworkMember> a = network.getSetting(NetworkSettings.NETWORK_PLAYERS);
        ListNBT list = new ListNBT();
        if (!a.isEmpty()) {
            a.forEach(s -> list.add((Object)s.writeNetworkNBT(new CompoundNBT())));
        }
        if (!(players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()).isEmpty()) {
            players.stream().filter(p -> a.stream().noneMatch(s -> s.getPlayerUUID().equals(p.func_110124_au()))).forEach(s -> list.add((Object)NetworkMember.createNetworkMember((PlayerEntity)s, FluxNetworkData.getPermission((PlayerEntity)s)).writeNetworkNBT(new CompoundNBT())));
        }
        nbt.func_218657_a(PLAYER_LIST, (INBT)list);
    }

    private static EnumAccessType getPermission(PlayerEntity player) {
        ISuperAdmin superAdmin = (ISuperAdmin)player.getCapability(Capabilities.SUPER_ADMIN, null).orElse(null);
        return superAdmin != null && superAdmin.getPermission() ? EnumAccessType.SUPER_ADMIN : EnumAccessType.NONE;
    }

    public static void readConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        if (!nbt.func_74764_b(UNLOADED_CONNECTIONS)) {
            return;
        }
        ArrayList<FluxLiteConnector> a = new ArrayList<FluxLiteConnector>();
        ListNBT list = nbt.func_150295_c(UNLOADED_CONNECTIONS, 10);
        for (int i = 0; i < list.size(); ++i) {
            a.add(new FluxLiteConnector(list.func_150305_b(i)));
        }
        network.getSetting(NetworkSettings.ALL_CONNECTORS).addAll(a);
    }

    public static CompoundNBT writeConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List<IFluxConnector> a = network.getSetting(NetworkSettings.ALL_CONNECTORS);
        if (!a.isEmpty()) {
            ListNBT list = new ListNBT();
            a.forEach(s -> {
                if (!s.isChunkLoaded()) {
                    list.add((Object)s.writeCustomNBT(new CompoundNBT(), NBTType.DEFAULT));
                }
            });
            nbt.func_218657_a(UNLOADED_CONNECTIONS, (INBT)list);
        }
        return nbt;
    }

    public static void readAllConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        if (!nbt.func_74764_b(UNLOADED_CONNECTIONS)) {
            return;
        }
        ArrayList<FluxLiteConnector> a = new ArrayList<FluxLiteConnector>();
        ListNBT list = nbt.func_150295_c(UNLOADED_CONNECTIONS, 10);
        for (int i = 0; i < list.size(); ++i) {
            a.add(new FluxLiteConnector(list.func_150305_b(i)));
        }
        network.setSetting(NetworkSettings.ALL_CONNECTORS, a);
    }

    public static CompoundNBT writeAllConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List<IFluxConnector> a = network.getSetting(NetworkSettings.ALL_CONNECTORS);
        if (!a.isEmpty()) {
            ListNBT list = new ListNBT();
            a.forEach(s -> list.add((Object)s.writeCustomNBT(new CompoundNBT(), NBTType.DEFAULT)));
            nbt.func_218657_a(UNLOADED_CONNECTIONS, (INBT)list);
        }
        return nbt;
    }

    private void readChunks(CompoundNBT nbt) {
        if (!nbt.func_74764_b(LOADED_CHUNKS)) {
            return;
        }
        CompoundNBT tags = nbt.func_74775_l(LOADED_CHUNKS);
        for (String key : tags.func_150296_c()) {
            ListNBT list = tags.func_150295_c(key, 10);
            List pos = this.loadedChunks.computeIfAbsent(Integer.valueOf(key), l -> new ArrayList());
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                pos.add(new ChunkPos(tag.func_74762_e("x"), tag.func_74762_e("z")));
            }
        }
    }

    private CompoundNBT writeChunks(int dim, List<ChunkPos> pos, CompoundNBT nbt) {
        if (!pos.isEmpty()) {
            ListNBT list = new ListNBT();
            pos.forEach(p -> {
                CompoundNBT t = new CompoundNBT();
                t.func_74768_a("x", p.field_77276_a);
                t.func_74768_a("z", p.field_77275_b);
                list.add((Object)t);
            });
            nbt.func_218657_a(String.valueOf(dim), (INBT)list);
        }
        return nbt;
    }

    private static void readOldData(FluxNetworkBase network, CompoundNBT nbt) {
        network.network_id.setValue(nbt.func_74762_e(OLD_NETWORK_ID));
        network.network_name.setValue(nbt.func_74779_i(OLD_NETWORK_NAME));
        CompoundNBT color = nbt.func_74775_l(OLD_NETWORK_COLOR);
        network.network_color.setValue(color.func_74762_e("red") << 16 | color.func_74762_e("green") << 8 | color.func_74762_e("blue"));
        network.network_owner.setValue(nbt.func_186857_a(OWNER_UUID));
        int c = nbt.func_74762_e(OLD_NETWORK_ACCESS);
        network.network_security.setValue(c > 0 ? EnumSecurityType.ENCRYPTED : EnumSecurityType.PUBLIC);
        network.network_password.setValue(String.valueOf((int)(Math.random() * 1000000.0)));
        network.network_energy.setValue(EnergyType.FE);
        FluxNetworkData.readPlayers(network, nbt);
        FluxNetworkData.readConnections(network, nbt);
    }

    static {
        NETWORKS = "networks";
        LOADED_CHUNKS = "loadedChunks";
        UNIQUE_ID = "uniqueID";
        NETWORK_ID = "networkID";
        NETWORK_NAME = "networkName";
        NETWORK_COLOR = "networkColor";
        NETWORK_PASSWORD = "networkPassword";
        SECURITY_TYPE = "networkSecurity";
        ENERGY_TYPE = "networkEnergy";
        OWNER_UUID = "ownerUUID";
        WIRELESS_MODE = "wirelessMode";
        PLAYER_LIST = "playerList";
        NETWORK_FOLDERS = "folders";
        UNLOADED_CONNECTIONS = "unloaded";
        OLD_NETWORK_ID = "id";
        OLD_NETWORK_NAME = "name";
        OLD_NETWORK_COLOR = "colour";
        OLD_NETWORK_ACCESS = "access";
    }
}

