/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class SimpleObservableList<T>
extends ArrayList<T> {
    public List<IListWatcher<T>> watchers = new ArrayList<IListWatcher<T>>();

    public void addWatcher(IListWatcher<T> watcher) {
        if (!this.watchers.contains(watcher)) {
            this.watchers.add(watcher);
        }
    }

    public void removeWatcher(IListWatcher<T> watcher) {
        this.watchers.remove(watcher);
    }

    public void updateList(List<T> updatedList) {
        ArrayList newElements = Lists.newArrayList(updatedList);
        ArrayList currentElements = Lists.newArrayList((Iterable)this);
        currentElements.remove(newElements);
        Iterator it = newElements.iterator();
        while (it.hasNext()) {
        }
    }

    @Override
    public boolean add(T t) {
        boolean add = super.add(t);
        if (add) {
            this.watchers.forEach((? super T w) -> w.onElementAdded(t));
        }
        return add;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            this.watchers.forEach((? super T w) -> w.onElementRemoved(o));
        }
        return remove;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean addAll = super.addAll(c);
        if (addAll) {
            this.watchers.forEach(IListWatcher::onListChanged);
        }
        return addAll;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean addAll = super.addAll(index, c);
        if (addAll) {
            this.watchers.forEach(IListWatcher::onListChanged);
        }
        return addAll;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removeAll = super.removeAll(c);
        if (removeAll) {
            this.watchers.forEach(IListWatcher::onListChanged);
        }
        return removeAll;
    }

    @Override
    public void clear() {
        this.forEach((? super E e) -> this.watchers.forEach((? super T w) -> w.onElementRemoved(e)));
        super.clear();
    }

    @Override
    public T set(int index, T element) {
        Object set = super.set(index, element);
        this.watchers.forEach((? super T w) -> w.onElementRemoved(set));
        this.watchers.forEach((? super T w) -> w.onElementAdded(element));
        return set;
    }

    @Override
    public void add(int index, T element) {
        int original_size = this.size();
        super.add(index, element);
        if (this.size() != original_size) {
            this.watchers.forEach((? super T w) -> w.onElementAdded(element));
        }
    }

    public static interface IListWatcher<T> {
        public void onElementAdded(@Nullable T var1);

        public void onElementRemoved(@Nullable T var1);

        public void onListChanged();
    }
}

