/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.core;

import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class FluxShapes {
    public static final VoxelShape FLUX_POINT_CENTRE_VOXEL = VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.getBBFromPixels(5.5, 5.5, 5.5, 10.5, 10.5, 10.5));
    public static final VoxelShape FLUX_PLUG_CENTRE_VOXEL = VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.getBBFromPixels(4.0, 4.0, 4.0, 12.0, 12.0, 12.0));
    public static final AxisAlignedBB CONNECTOR_CABLE_BB_SHAPE = FluxShapes.getBBFromPixels(7.0, 1.0, 7.0, 9.0, 6.0, 9.0);
    public static final VoxelShape[] CONNECTOR_CABLE_BB_SHAPE_ROTATED_VOXELS = FluxShapes.getRotatedVoxels(CONNECTOR_CABLE_BB_SHAPE, Direction.values());
    public static final AxisAlignedBB CONNECTOR_PLATE_BB_SHAPE = FluxShapes.getBBFromPixels(5.0, 0.0, 5.0, 11.0, 1.0, 11.0);
    public static final VoxelShape[] CONNECTOR_PLATE_BB_SHAPE_ROTATED_VOXELS = FluxShapes.getRotatedVoxels(CONNECTOR_PLATE_BB_SHAPE, Direction.values());
    public static final VoxelShape[] CONNECTORS_ROTATED_VOXELS = new VoxelShape[]{VoxelShapes.func_197882_b((VoxelShape)CONNECTOR_CABLE_BB_SHAPE_ROTATED_VOXELS[0], (VoxelShape)CONNECTOR_PLATE_BB_SHAPE_ROTATED_VOXELS[0], (IBooleanFunction)IBooleanFunction.field_223244_o_), VoxelShapes.func_197882_b((VoxelShape)CONNECTOR_CABLE_BB_SHAPE_ROTATED_VOXELS[1], (VoxelShape)CONNECTOR_PLATE_BB_SHAPE_ROTATED_VOXELS[1], (IBooleanFunction)IBooleanFunction.field_223244_o_), VoxelShapes.func_197882_b((VoxelShape)CONNECTOR_CABLE_BB_SHAPE_ROTATED_VOXELS[2], (VoxelShape)CONNECTOR_PLATE_BB_SHAPE_ROTATED_VOXELS[2], (IBooleanFunction)IBooleanFunction.field_223244_o_), VoxelShapes.func_197882_b((VoxelShape)CONNECTOR_CABLE_BB_SHAPE_ROTATED_VOXELS[3], (VoxelShape)CONNECTOR_PLATE_BB_SHAPE_ROTATED_VOXELS[3], (IBooleanFunction)IBooleanFunction.field_223244_o_), VoxelShapes.func_197882_b((VoxelShape)CONNECTOR_CABLE_BB_SHAPE_ROTATED_VOXELS[4], (VoxelShape)CONNECTOR_PLATE_BB_SHAPE_ROTATED_VOXELS[4], (IBooleanFunction)IBooleanFunction.field_223244_o_), VoxelShapes.func_197882_b((VoxelShape)CONNECTOR_CABLE_BB_SHAPE_ROTATED_VOXELS[5], (VoxelShape)CONNECTOR_PLATE_BB_SHAPE_ROTATED_VOXELS[5], (IBooleanFunction)IBooleanFunction.field_223244_o_)};
    public static VoxelShape FLUX_CONTROLLER_VOXEL = FluxShapes.combineAll(VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.getBBFromPixels(0.0, 1.0, 0.0, 16.0, 15.0, 16.0)), VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.getBBFromPixels(1.0, 0.0, 1.0, 3.0, 16.0, 3.0)), VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.getBBFromPixels(1.0, 0.0, 13.0, 3.0, 16.0, 15.0)), VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.getBBFromPixels(13.0, 0.0, 1.0, 15.0, 16.0, 3.0)), VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.getBBFromPixels(13.0, 0.0, 13.0, 15.0, 16.0, 15.0)));
    public static final double PIXEL = 0.0625;

    public static Vec3d getVec3DFromPixels(double x, double y, double z) {
        return new Vec3d(x * 0.0625, y * 0.0625, z * 0.0625);
    }

    public static AxisAlignedBB getBBFromPixels(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new AxisAlignedBB(minX * 0.0625, minY * 0.0625, minZ * 0.0625, maxX * 0.0625, maxY * 0.0625, maxZ * 0.0625);
    }

    public static VoxelShape[] getRotatedVoxels(AxisAlignedBB downShape, Direction[] dirs) {
        VoxelShape[] rotated = new VoxelShape[dirs.length];
        for (int i = 0; i < dirs.length; ++i) {
            rotated[i] = VoxelShapes.func_197881_a((AxisAlignedBB)FluxShapes.rotate(downShape, dirs[i]));
        }
        return rotated;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB shape, Direction dir) {
        return FluxShapes.rotateToDirection(shape.func_72317_d(-0.5, -0.5, -0.5), dir).func_72317_d(0.5, 0.5, 0.5);
    }

    private static AxisAlignedBB rotateToDirection(AxisAlignedBB boundingBox, Direction side) {
        switch (side) {
            case DOWN: {
                return boundingBox;
            }
            case UP: {
                return new AxisAlignedBB(boundingBox.field_72340_a, -boundingBox.field_72338_b, -boundingBox.field_72339_c, boundingBox.field_72336_d, -boundingBox.field_72337_e, -boundingBox.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(boundingBox.field_72340_a, -boundingBox.field_72339_c, boundingBox.field_72338_b, boundingBox.field_72336_d, -boundingBox.field_72334_f, boundingBox.field_72337_e);
            }
            case SOUTH: {
                return new AxisAlignedBB(-boundingBox.field_72340_a, boundingBox.field_72339_c, -boundingBox.field_72338_b, -boundingBox.field_72336_d, boundingBox.field_72334_f, -boundingBox.field_72337_e);
            }
            case WEST: {
                return new AxisAlignedBB(boundingBox.field_72338_b, -boundingBox.field_72339_c, -boundingBox.field_72340_a, boundingBox.field_72337_e, -boundingBox.field_72334_f, -boundingBox.field_72336_d);
            }
            case EAST: {
                return new AxisAlignedBB(-boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a, -boundingBox.field_72337_e, boundingBox.field_72334_f, boundingBox.field_72336_d);
            }
        }
        return boundingBox;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB box, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return box;
            }
            case CLOCKWISE_90: {
                return new AxisAlignedBB(-box.field_72339_c, box.field_72338_b, box.field_72340_a, -box.field_72334_f, box.field_72337_e, box.field_72336_d);
            }
            case CLOCKWISE_180: {
                return new AxisAlignedBB(-box.field_72340_a, box.field_72338_b, -box.field_72339_c, -box.field_72336_d, box.field_72337_e, -box.field_72334_f);
            }
            case COUNTERCLOCKWISE_90: {
                return new AxisAlignedBB(box.field_72339_c, box.field_72338_b, -box.field_72340_a, box.field_72334_f, box.field_72337_e, -box.field_72336_d);
            }
        }
        return box;
    }

    public static VoxelShape combineAll(VoxelShape ... shapes) {
        VoxelShape shape = null;
        for (VoxelShape nextShape : shapes) {
            shape = shape == null ? nextShape : VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)nextShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }
}

