/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import sonar.fluxnetworks.api.tiles.IFluxConnector;

public class PriorityGroup<T extends IFluxConnector> {
    public final int priority;
    public final List<T> connectors;

    public PriorityGroup(int priority) {
        this.priority = priority;
        this.connectors = new ArrayList<T>();
    }

    public int getPriority() {
        return this.priority;
    }

    public List<T> getConnectors() {
        return this.connectors;
    }

    public static <T extends IFluxConnector> PriorityGroup<T> getOrCreateGroup(int priority, List<PriorityGroup<T>> groups) {
        Optional<PriorityGroup> group = groups.stream().filter(g -> g.priority == priority).findFirst();
        if (!group.isPresent()) {
            PriorityGroup<T> newGroup = new PriorityGroup<T>(priority);
            groups.add(newGroup);
            return newGroup;
        }
        return group.get();
    }
}

