/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import sonar.fluxnetworks.api.network.FluxCacheTypes;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.tiles.IFluxPlug;
import sonar.fluxnetworks.api.tiles.IFluxPoint;
import sonar.fluxnetworks.api.tiles.IFluxStorage;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

public class NetworkStatistics {
    public final IFluxNetwork network;
    private int timer;
    public int fluxPlugCount;
    public int fluxPointCount;
    public int fluxControllerCount;
    public int fluxStorageCount;
    public long energyInput;
    public long energyOutput;
    public List<Long> energyChange = new ArrayList<Long>();
    public long totalBuffer;
    public long totalEnergy;
    private long energyChange5;
    private long energyInput4;
    private long energyOutput4;
    public long average_tick_micro = 0L;
    public long running_total_micro = 0L;
    public long running_total_count = 0L;
    public long network_nano_time;
    public long network_tick;

    public NetworkStatistics(IFluxNetwork network) {
        this.network = network;
        for (int i = 0; i < 6; ++i) {
            this.energyChange.add(0L);
        }
    }

    public void startProfiling() {
        this.network_nano_time = System.nanoTime();
    }

    public void stopProfiling() {
        this.network_tick += (System.nanoTime() - this.network_nano_time) / 1000L;
    }

    public void onStartServerTick() {
        this.network_tick = 0L;
    }

    public void onEndServerTick() {
        if (this.timer == 0) {
            this.weakestTick();
        }
        if (this.timer % 5 == 0) {
            this.weakTick();
        }
        if (this.timer % 20 == 0) {
            this.weakerTick();
        }
        this.running_total_micro += this.network_tick;
        ++this.running_total_count;
        if (this.running_total_count >= 20L) {
            this.average_tick_micro = this.running_total_micro / this.running_total_count;
            this.running_total_micro = 0L;
            this.running_total_count = 0L;
        }
        ++this.timer;
        this.timer %= 100;
    }

    private void weakTick() {
        List<IFluxPlug> plugs = this.network.getConnections(FluxCacheTypes.plug);
        plugs.forEach(p -> {
            if (!(p instanceof TileFluxStorage)) {
                this.energyInput4 += p.getTransferHandler().getChange();
            }
        });
        List<IFluxPoint> points = this.network.getConnections(FluxCacheTypes.point);
        points.forEach(p -> {
            if (!(p instanceof TileFluxStorage)) {
                this.energyOutput4 -= p.getTransferHandler().getChange();
            }
        });
    }

    private void weakerTick() {
        this.totalBuffer = 0L;
        this.totalEnergy = 0L;
        List<IFluxPlug> plugs = this.network.getConnections(FluxCacheTypes.plug);
        plugs.forEach(p -> {
            if (p instanceof TileFluxPlug) {
                this.totalBuffer += p.getTransferHandler().getBuffer();
            }
        });
        List<IFluxStorage> storages = this.network.getConnections(FluxCacheTypes.storage);
        storages.forEach(p -> this.totalEnergy += p.getEnergy());
        this.fluxControllerCount = this.network.getConnections(FluxCacheTypes.controller).size();
        this.fluxStorageCount = storages.size();
        this.fluxPlugCount = plugs.size() - this.fluxStorageCount;
        this.fluxPointCount = this.network.getConnections(FluxCacheTypes.point).size() - this.fluxStorageCount - this.fluxControllerCount;
        this.energyInput = this.energyInput4 / 4L;
        this.energyOutput = this.energyOutput4 / 4L;
        this.energyInput4 = 0L;
        this.energyOutput4 = 0L;
        this.energyChange5 += Math.max(this.energyInput, this.energyOutput);
    }

    private void weakestTick() {
        long change = this.energyChange5 / 5L;
        this.energyChange5 = 0L;
        for (int i = 0; i < this.energyChange.size(); ++i) {
            if (i <= 0) continue;
            this.energyChange.set(i - 1, this.energyChange.get(i));
        }
        this.energyChange.set(5, change);
    }

    public int getConnectionCount() {
        return this.fluxPlugCount + this.fluxPointCount + this.fluxStorageCount + this.fluxControllerCount;
    }

    public CompoundNBT writeNBT(CompoundNBT tag) {
        tag.func_74768_a("i1", this.fluxPlugCount);
        tag.func_74768_a("i2", this.fluxPointCount);
        tag.func_74768_a("i3", this.fluxControllerCount);
        tag.func_74768_a("i4", this.fluxStorageCount);
        tag.func_74772_a("l1", this.energyInput);
        tag.func_74772_a("l2", this.energyOutput);
        tag.func_74772_a("l3", this.totalBuffer);
        tag.func_74772_a("l4", this.totalEnergy);
        tag.func_74772_a("l5", this.average_tick_micro);
        for (int i = 0; i < this.energyChange.size(); ++i) {
            tag.func_74772_a("a" + i, this.energyChange.get(i).longValue());
        }
        return tag;
    }

    public void readNBT(CompoundNBT tag) {
        this.fluxPlugCount = tag.func_74762_e("i1");
        this.fluxPointCount = tag.func_74762_e("i2");
        this.fluxControllerCount = tag.func_74762_e("i3");
        this.fluxStorageCount = tag.func_74762_e("i4");
        this.energyInput = tag.func_74763_f("l1");
        this.energyOutput = tag.func_74763_f("l2");
        this.totalBuffer = tag.func_74763_f("l3");
        this.totalEnergy = tag.func_74763_f("l4");
        this.average_tick_micro = tag.func_74763_f("l5");
        for (int i = 0; i < 6; ++i) {
            this.energyChange.set(i, tag.func_74763_f("a" + i));
        }
    }
}

