/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.EnumSecurityType;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popups.PopUpCore;
import sonar.fluxnetworks.client.gui.popups.PopUpCustomColour;
import sonar.fluxnetworks.common.core.FluxUtils;

public abstract class GuiTabEditAbstract
extends GuiTabCore {
    public InvisibleButton redirectButton;
    protected List<ColorButton> colorButtons = Lists.newArrayList();
    protected EnumSecurityType securityType;
    public EnergyType energyType;
    public ColorButton color;
    public FluxTextWidget name;
    public FluxTextWidget password;

    public GuiTabEditAbstract(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
    }

    public abstract void onEditSettingsChanged();

    @Override
    public void init() {
        super.init();
        this.colorButtons.clear();
        this.buttonLists.add(this.colorButtons);
        this.configureNavigationButtons(this.getNavigationTab(), this.navigationTabs);
        if (this.networkValid || this.getNavigationTab() == EnumNavigationTabs.TAB_CREATE) {
            int l = this.font.func_78256_a(FluxTranslate.NETWORK_NAME.t());
            this.name = FluxTextWidget.create("", this.font, this.field_147003_i + 20 + l, this.field_147009_r + 28, 140 - l, 12);
            this.name.func_146203_f(24);
            this.name.func_212954_a(string -> this.onEditSettingsChanged());
            l = this.font.func_78256_a(FluxTranslate.NETWORK_PASSWORD.t());
            this.password = FluxTextWidget.create("", this.font, this.field_147003_i + 20 + l, this.field_147009_r + 62, 140 - l, 12).setTextInvisible();
            this.password.func_146203_f(16);
            this.password.func_212954_a(string -> this.onEditSettingsChanged());
            this.addButton((Widget)this.name);
            this.addButton((Widget)this.password);
        } else if (!this.networkValid) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabEditAbstract.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.addButton((Widget)this.redirectButton);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.getNavigationTab() == EnumNavigationTabs.TAB_CREATE || this.networkValid) {
            this.drawCenteredString(this.font, this.getNavigationTab().getTranslatedName(), 88, 10, 0xB4B4B4);
            this.font.func_211126_b(FluxTranslate.NETWORK_NAME.t() + ":", 14.0f, 30.0f, 0x606060);
            this.font.func_211126_b(FluxTranslate.NETWORK_SECURITY.t() + ": " + TextFormatting.AQUA + this.securityType.getName(), 14.0f, 50.0f, 0x606060);
            if (this.securityType == EnumSecurityType.ENCRYPTED) {
                this.font.func_211126_b(FluxTranslate.NETWORK_PASSWORD.t() + ": ", 14.0f, 64.0f, 0x606060);
            }
            this.font.func_211126_b(FluxTranslate.NETWORK_ENERGY.t() + ": " + TextFormatting.AQUA + this.energyType.getName(), 14.0f, 78.0f, 0x606060);
            this.font.func_211126_b(FluxTranslate.NETWORK_COLOR.t() + ":", 14.0f, 97.0f, 0x606060);
        }
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (mouseX > (double)(this.field_147003_i + 50) && mouseX < (double)(this.field_147003_i + 150) && mouseY > (double)(this.field_147009_r + 48) && mouseY < (double)(this.getGuiTop() + 60)) {
                this.securityType = (EnumSecurityType)FluxUtils.incrementEnum((Enum)this.securityType, (Enum[])EnumSecurityType.values());
                this.password.func_146180_a("");
                this.password.func_146189_e(!this.password.func_146176_q());
                this.onEditSettingsChanged();
                return true;
            }
            if (mouseX > (double)(this.field_147003_i + 50) && mouseX < (double)(this.field_147003_i + 150) && mouseY > (double)(this.field_147009_r + 76) && mouseY < (double)(this.getGuiTop() + 88)) {
                this.energyType = (EnergyType)FluxUtils.incrementEnum((Enum)this.energyType, (Enum[])EnergyType.values());
                this.onEditSettingsChanged();
                return true;
            }
        }
        return false;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof ColorButton) {
            this.color.selected = false;
            this.color = (ColorButton)button;
            this.color.selected = true;
            this.onEditSettingsChanged();
            if (mouseButton == 1) {
                this.openPopUp(new PopUpCustomColour(this, this.color.color, this.player, this.connector));
            }
        }
    }

    @Override
    public void onPopUpClose(PopUpCore popUp) {
        super.onPopUpClose(popUp);
        if (popUp instanceof PopUpCustomColour) {
            this.color.color = ((PopUpCustomColour)popUp).currentColour;
        }
    }
}

