/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.network.EnumAccessType;
import sonar.fluxnetworks.api.network.EnumConnectionType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopUpHost;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.item.AdminConfiguratorItem;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;
import sonar.fluxnetworks.common.network.ConfiguratorNetworkConnectPacket;
import sonar.fluxnetworks.common.network.TilePacket;
import sonar.fluxnetworks.common.network.TilePacketEnum;
import sonar.fluxnetworks.common.network.TilePacketHandler;

public abstract class GuiFluxCore
extends GuiPopUpHost {
    public List<List<? extends GuiButtonCore>> buttonLists = Lists.newArrayList();
    protected List<NormalButton> buttons = Lists.newArrayList();
    protected List<SlidedSwitchButton> switches = Lists.newArrayList();
    public IFluxNetwork network;
    public EnumAccessType accessPermission = EnumAccessType.NONE;
    protected boolean networkValid;
    private int timer1;

    public GuiFluxCore(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.network = FluxNetworkCache.instance.getClientNetwork(connector.getNetworkID());
        this.networkValid = !this.network.isInvalid();
    }

    @Override
    public int getGuiColouring() {
        return this.network.getSetting(NetworkSettings.NETWORK_COLOR);
    }

    public void init() {
        super.init();
        this.buttonLists.clear();
        this.buttons.clear();
        this.switches.clear();
        this.buttonLists.add(this.buttons);
        this.buttonLists.add(this.switches);
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.buttonLists.forEach(list -> list.forEach(b -> b.drawButton(this.minecraft, mouseX, mouseY, this.field_147003_i, this.field_147009_r)));
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        this.buttonLists.forEach(list -> list.forEach(b -> b.updateButton(partialTicks, mouseX, mouseY)));
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        for (List<? extends GuiButtonCore> list : this.buttonLists) {
            for (GuiButtonCore guiButtonCore : list) {
                if (!guiButtonCore.clickable || !guiButtonCore.isMouseHovered(this.minecraft, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                this.onButtonClicked(guiButtonCore, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r, mouseButton);
                return true;
            }
        }
        return super.mouseClickedMain(mouseX, mouseY, mouseButton);
    }

    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
    }

    public void tick() {
        super.tick();
        if (this.timer1 == 0) {
            this.network = FluxNetworkCache.instance.getClientNetwork(this.connector.getNetworkID());
            this.networkValid = !this.network.isInvalid();
        }
        ++this.timer1;
        this.timer1 %= 20;
    }

    public void onClose() {
        super.onClose();
        FluxNetworks.proxy.setFeedback(EnumFeedbackInfo.NONE, false);
        FluxNetworks.proxy.setFeedback(EnumFeedbackInfo.NONE, true);
    }

    protected void renderNavigationPrompt(String error, String prompt) {
        RenderSystem.pushMatrix();
        this.drawCenteredString(this.font, error, this.field_146999_f / 2, 16, 0x808080);
        RenderSystem.scaled((double)0.625, (double)0.625, (double)0.625);
        this.drawCenteredString(this.font, FluxTranslate.CLICK.t() + TextFormatting.AQUA + ' ' + prompt + ' ' + TextFormatting.RESET + FluxTranslate.ABOVE.t(), (int)((double)(this.field_146999_f / 2) * 1.6), 41, 0x808080);
        RenderSystem.scaled((double)1.6, (double)1.6, (double)1.6);
        RenderSystem.popMatrix();
    }

    protected void renderTransfer(IFluxConnector fluxConnector, int color, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        this.screenUtils.resetGuiColouring();
        this.font.func_211126_b(FluxUtils.getTransferInfo(fluxConnector.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), fluxConnector.getTransferHandler().getChange()), (float)x, (float)y, color);
        this.font.func_211126_b((fluxConnector.getConnectionType().isStorage() ? FluxTranslate.ENERGY.t() : FluxTranslate.BUFFER.t()) + ": " + TextFormatting.BLUE + FluxUtils.format(fluxConnector.getTransferHandler().getBuffer(), FluxUtils.TypeNumberFormat.COMMAS, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), (float)x, (float)(y + 10), 0xFFFFFF);
        this.screenUtils.renderItemStack(fluxConnector.getDisplayStack(), x - 20, y + 1);
        RenderSystem.popMatrix();
    }

    protected List<String> getFluxInfo(IFluxConnector flux) {
        ArrayList list = Lists.newArrayList();
        list.add(TextFormatting.BOLD + flux.getCustomName());
        CompoundNBT tag = flux.getDisplayStack().func_179543_a("FluxData");
        if (flux.isChunkLoaded()) {
            if (flux.isForcedLoading()) {
                list.add(TextFormatting.AQUA + FluxTranslate.FORCED_LOADING.t());
            }
            list.add(FluxUtils.getTransferInfo(flux.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), flux.getChange()));
            if (flux.getConnectionType() == EnumConnectionType.STORAGE) {
                list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(flux.getBuffer()) + "RF");
            } else {
                list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(flux.getBuffer()) + "RF");
            }
        } else {
            list.add(TextFormatting.RED + FluxTranslate.CHUNK_UNLOADED.t());
            if (tag != null) {
                if (tag.func_74764_b("energy")) {
                    list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(tag.func_74762_e("energy")) + "RF");
                } else {
                    list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(tag.func_74763_f("buffer")) + "RF");
                }
            }
        }
        list.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.GREEN + (flux.getDisableLimit() ? FluxTranslate.UNLIMITED.t() : Long.valueOf(flux.getCurrentLimit())));
        list.add(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.GREEN + (flux.getSurgeMode() ? FluxTranslate.SURGE.t() : Integer.valueOf(flux.getPriority())));
        list.add(TextFormatting.ITALIC + flux.getCoords().getStringInfo());
        return list;
    }

    public void onSuperAdminChanged() {
    }

    public void setConnectedNetwork(int networkID, String password) {
        if (this.connector instanceof IFluxConnector) {
            PacketHandler.INSTANCE.sendToServer((Object)new TilePacket(TilePacketEnum.SET_NETWORK, TilePacketHandler.getSetNetworkPacket(networkID, password), ((IFluxConnector)this.connector).getCoords().getPos(), ((IFluxConnector)this.connector).getCoords().getDimension()));
        }
        if (this.connector instanceof AdminConfiguratorItem.ContainerProvider) {
            FluxNetworks.proxy.setAdminViewingNetworkID(networkID);
            FluxNetworks.proxy.setAdminViewingNetwork(FluxNetworkCache.instance.getClientNetwork(networkID));
        }
        if (this.connector instanceof FluxConfiguratorItem.ContainerProvider) {
            PacketHandler.INSTANCE.sendToServer((Object)new ConfiguratorNetworkConnectPacket(networkID, password));
        }
    }
}

