/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.integration.jei.strainer;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.waterstrainer.integration.jei.WaterStrainerPlugin;
import mods.waterstrainer.integration.jei.strainer.StrainerRecipe;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class StrainerCategory
implements IRecipeCategory<StrainerRecipe> {
    private final IDrawable BACKGROUND;
    private final IDrawable ICON;
    private final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("waterstrainer", "textures/gui/jei_strainer.png");

    public StrainerCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createDrawable(this.BACKGROUND_LOCATION, 0, 0, 92, 122);
        this.ICON = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ItemRegistry.strainer_survivalist));
    }

    public ResourceLocation getUid() {
        return WaterStrainerPlugin.UID_CAT_STRAINER;
    }

    public Class<? extends StrainerRecipe> getRecipeClass() {
        return StrainerRecipe.class;
    }

    public String getTitle() {
        return "Straining";
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setIngredients(StrainerRecipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.getInput());
        ingredients.setOutputLists(VanillaTypes.ITEM, recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, StrainerRecipe recipe, IIngredients ingredients) {
        int istart;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 37, 4);
        guiItemStacks.set(ingredients);
        List ingredOutputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (ingredOutputs.isEmpty()) {
            return;
        }
        List outputs = (List)ingredOutputs.get(0);
        int icur = istart = 1;
        int imax = 25;
        ArrayList outputlist = new ArrayList();
        while (outputlist.size() < imax) {
            outputlist.add(new ArrayList());
        }
        for (int index = 0; index < outputs.size(); ++index) {
            ((List)outputlist.get(index % imax)).add(outputs.get(index));
        }
        for (int i = 0; i < outputs.size(); ++i) {
            int column = (icur - 1) / 5;
            int row = (icur - 1) % 5;
            int x = 1 + 18 * row;
            int y = 31 + 18 * column;
            guiItemStacks.init(icur, false, x, y);
            List output = (List)outputlist.get(icur - 1);
            guiItemStacks.set(icur, output);
            icur = icur >= imax ? istart : icur + 1;
        }
    }
}

