/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.file;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseFile {
    protected static final String NEW_LINE = System.lineSeparator();
    protected List<String> localFileData = new ArrayList<String>();

    private static String buildString(List<String> input) {
        if (input == null || input.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : input) {
            sb.append(s);
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public boolean createFile(List<String> content) {
        if (this.getDeleteOnCreation()) {
            this.deleteFile();
        }
        try {
            Files.write(Paths.get(this.getFilePath(), new String[0]), (BaseFile.buildString(this.getDefaultContent()) + BaseFile.buildString(content)).getBytes(), StandardOpenOption.CREATE);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean createFile() {
        return this.createFile(null);
    }

    public boolean readFile() {
        try {
            this.localFileData = Files.readAllLines(Paths.get(this.getFilePath(), new String[0]));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteFile() {
        try {
            Files.deleteIfExists(Paths.get(this.getFilePath(), new String[0]));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void clearFileData() {
        this.localFileData.clear();
    }

    public void addFileData(String str) {
        if (str != null) {
            this.localFileData.add(str);
        }
    }

    public void addFileData(List<String> strings) {
        if (strings != null) {
            for (String str : strings) {
                this.localFileData.add(str);
            }
        }
    }

    public void saveFileData() {
        this.createFile(this.localFileData);
    }

    public List<String> getLocalFileData() {
        return this.localFileData;
    }

    protected boolean getDeleteOnCreation() {
        return false;
    }

    public abstract void init();

    protected abstract String getFilePath();

    protected abstract List<String> getDefaultContent();
}

