/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static int IDLE_TIME;
    public static int IDLE_TIME_DEVIATION;
    public static int DURABILITY_STRAINER_SURVIVALIST;
    public static int DURABILITY_STRAINER_SURVIVALIST_SOLID;
    public static int DURABILITY_STRAINER_SURVIVALIST_REINFORCED;
    public static int DURABILITY_STRAINER_FISHERMAN;
    public static int DURABILITY_STRAINER_FISHERMAN_SOLID;
    public static int DURABILITY_STRAINER_FISHERMAN_REINFORCED;
    public static int BONUS_SOLID_EFFICIENCY;
    public static int BONUS_REINFORCED_EFFICIENCY;
    public static boolean MISC_ENABLE_EFFICIENCY;
    public static boolean MISC_ENABLE_ENCHANTING;
    public static boolean ENABLE_STRAINER_SURVIVALIST;
    public static boolean ENABLE_STRAINER_SURVIVALIST_SOLID;
    public static boolean ENABLE_STRAINER_SURVIVALIST_REINFORCED;
    public static boolean ENABLE_STRAINER_FISHERMAN;
    public static boolean ENABLE_STRAINER_FISHERMAN_SOLID;
    public static boolean ENABLE_STRAINER_FISHERMAN_REINFORCED;
    public static ForgeConfigSpec.IntValue IDLE_TIME_VALUE;
    public static ForgeConfigSpec.IntValue IDLE_TIME_DEVIATION_VALUE;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST_VALUE;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST_SOLID_VALUE;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST_REINFORCED_VALUE;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN_VALUE;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN_SOLID_VALUE;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN_REINFORCED_VALUE;
    public static ForgeConfigSpec.IntValue BONUS_SOLID_EFFICIENCY_VALUE;
    public static ForgeConfigSpec.IntValue BONUS_REINFORCED_EFFICIENCY_VALUE;
    public static ForgeConfigSpec.BooleanValue MISC_ENABLE_EFFICIENCY_VALUE;
    public static ForgeConfigSpec.BooleanValue MISC_ENABLE_ENCHANTING_VALUE;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_SURVIVALIST_VALUE;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_SURVIVALIST_SOLID_VALUE;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_SURVIVALIST_REINFORCED_VALUE;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_FISHERMAN_VALUE;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_FISHERMAN_SOLID_VALUE;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_FISHERMAN_REINFORCED_VALUE;

    public Config(ForgeConfigSpec.Builder builder) {
        builder.push("IdleTime");
        IDLE_TIME_VALUE = builder.comment("Time (in seconds) until a strainer catches an item. [Default: 30]").defineInRange("idle_time", 30, 0, 0x6666666);
        IDLE_TIME_DEVIATION_VALUE = builder.comment("Adds a deviation to the idle time to make it more random. [Default: 5]").defineInRange("idle_time_deviation", 5, 0, 0x6666666);
        builder.pop();
        builder.comment("Set the max durability (uses) for each strainer type.\nUse 0 for infinite durability.\nDefault:\n- Normal: 120\n- Solid: 720\n- Reinforced: 8640").push("Durability");
        DURABILITY_STRAINER_SURVIVALIST_VALUE = builder.defineInRange("durability_strainer_survivalist", 120, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_SURVIVALIST_SOLID_VALUE = builder.defineInRange("durability_strainer_survivalist_solid", 720, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_SURVIVALIST_REINFORCED_VALUE = builder.defineInRange("durability_strainer_survivalist_reinforced", 8640, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_FISHERMAN_VALUE = builder.defineInRange("durability_strainer_fisherman", 120, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_FISHERMAN_SOLID_VALUE = builder.defineInRange("durability_strainer_fisherman_solid", 720, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_FISHERMAN_REINFORCED_VALUE = builder.defineInRange("durability_strainer_fisherman_reinforced", 8640, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Bonus");
        BONUS_SOLID_EFFICIENCY_VALUE = builder.comment("Bonus efficiency (in %) for Solid Strainers. Use 0 to disable bonus efficiency. [Default: 10]").defineInRange("bonus_solid_efficiency", 10, 0, Integer.MAX_VALUE);
        BONUS_REINFORCED_EFFICIENCY_VALUE = builder.comment("Bonus efficiency (in %) for Reinforced Strainers. Use 0 to disable bonus efficiency. [Default: 25]").defineInRange("bonus_reinforced_efficiency", 25, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Misc");
        MISC_ENABLE_EFFICIENCY_VALUE = builder.comment("Strainers are more or less efficient based on their placement (liquid height, biome, adjacent strainers).\nBonus efficiency from strainer type and enchantments still apply. [Default: true]").define("misc_enable_efficiency", true);
        MISC_ENABLE_ENCHANTING_VALUE = builder.comment("Reinforced Strainers (Tier 3) can be enchanted. [Default: true]").define("misc_enable_enchanting", true);
        builder.pop();
        builder.comment("This feature is currently disabled").push("Recipes");
        ENABLE_STRAINER_SURVIVALIST_VALUE = builder.define("enable_strainer_survivalist", true);
        ENABLE_STRAINER_SURVIVALIST_SOLID_VALUE = builder.define("enable_strainer_survivalist_solid", true);
        ENABLE_STRAINER_SURVIVALIST_REINFORCED_VALUE = builder.define("enable_strainer_survivalist_reinforced", true);
        ENABLE_STRAINER_FISHERMAN_VALUE = builder.define("enable_strainer_fisherman", true);
        ENABLE_STRAINER_FISHERMAN_SOLID_VALUE = builder.define("enable_strainer_fisherman_solid", true);
        ENABLE_STRAINER_FISHERMAN_REINFORCED_VALUE = builder.define("enable_strainer_fisherman_reinforced", true);
        builder.pop();
    }

    public static void refreshConfigValues() {
        IDLE_TIME = (Integer)IDLE_TIME_VALUE.get();
        IDLE_TIME_DEVIATION = (Integer)IDLE_TIME_DEVIATION_VALUE.get();
        DURABILITY_STRAINER_SURVIVALIST = (Integer)DURABILITY_STRAINER_SURVIVALIST_VALUE.get();
        DURABILITY_STRAINER_SURVIVALIST_SOLID = (Integer)DURABILITY_STRAINER_SURVIVALIST_SOLID_VALUE.get();
        DURABILITY_STRAINER_SURVIVALIST_REINFORCED = (Integer)DURABILITY_STRAINER_SURVIVALIST_REINFORCED_VALUE.get();
        DURABILITY_STRAINER_FISHERMAN = (Integer)DURABILITY_STRAINER_FISHERMAN_VALUE.get();
        DURABILITY_STRAINER_FISHERMAN_SOLID = (Integer)DURABILITY_STRAINER_FISHERMAN_SOLID_VALUE.get();
        DURABILITY_STRAINER_FISHERMAN_REINFORCED = (Integer)DURABILITY_STRAINER_FISHERMAN_REINFORCED_VALUE.get();
        BONUS_SOLID_EFFICIENCY = (Integer)BONUS_SOLID_EFFICIENCY_VALUE.get();
        BONUS_REINFORCED_EFFICIENCY = (Integer)BONUS_REINFORCED_EFFICIENCY_VALUE.get();
        MISC_ENABLE_EFFICIENCY = (Boolean)MISC_ENABLE_EFFICIENCY_VALUE.get();
        MISC_ENABLE_ENCHANTING = (Boolean)MISC_ENABLE_ENCHANTING_VALUE.get();
        ENABLE_STRAINER_SURVIVALIST = (Boolean)ENABLE_STRAINER_SURVIVALIST_VALUE.get();
        ENABLE_STRAINER_SURVIVALIST_SOLID = (Boolean)ENABLE_STRAINER_SURVIVALIST_SOLID_VALUE.get();
        ENABLE_STRAINER_SURVIVALIST_REINFORCED = (Boolean)ENABLE_STRAINER_SURVIVALIST_REINFORCED_VALUE.get();
        ENABLE_STRAINER_FISHERMAN = (Boolean)ENABLE_STRAINER_FISHERMAN_VALUE.get();
        ENABLE_STRAINER_FISHERMAN_SOLID = (Boolean)ENABLE_STRAINER_FISHERMAN_SOLID_VALUE.get();
        ENABLE_STRAINER_FISHERMAN_REINFORCED = (Boolean)ENABLE_STRAINER_FISHERMAN_REINFORCED_VALUE.get();
    }

    static {
        IDLE_TIME = 30;
        IDLE_TIME_DEVIATION = 5;
        DURABILITY_STRAINER_SURVIVALIST = 120;
        DURABILITY_STRAINER_SURVIVALIST_SOLID = 720;
        DURABILITY_STRAINER_SURVIVALIST_REINFORCED = 8640;
        DURABILITY_STRAINER_FISHERMAN = 120;
        DURABILITY_STRAINER_FISHERMAN_SOLID = 720;
        DURABILITY_STRAINER_FISHERMAN_REINFORCED = 8640;
        BONUS_SOLID_EFFICIENCY = 10;
        BONUS_REINFORCED_EFFICIENCY = 25;
        MISC_ENABLE_EFFICIENCY = true;
        MISC_ENABLE_ENCHANTING = true;
        ENABLE_STRAINER_SURVIVALIST = true;
        ENABLE_STRAINER_SURVIVALIST_SOLID = true;
        ENABLE_STRAINER_SURVIVALIST_REINFORCED = true;
        ENABLE_STRAINER_FISHERMAN = true;
        ENABLE_STRAINER_FISHERMAN_SOLID = true;
        ENABLE_STRAINER_FISHERMAN_REINFORCED = true;
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }
}

