/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.save;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRequestTemplate;
import com.direwolf20.buildinggadgets.common.network.packets.SplitPacketUpdateTemplate;
import com.direwolf20.buildinggadgets.common.save.TemplateSave;
import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.template.Template;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.util.TriConsumer;

public final class SaveTemplateProvider
implements ITemplateProvider {
    private final Supplier<TemplateSave> save;
    private final Set<ITemplateProvider.IUpdateListener> updateListeners;

    public SaveTemplateProvider(Supplier<TemplateSave> save) {
        this.save = save;
        this.updateListeners = Collections.newSetFromMap(new WeakHashMap());
    }

    public TemplateSave getSave() {
        return this.save.get();
    }

    @Override
    public Template getTemplateForKey(ITemplateKey key) {
        UUID id = this.getId(key);
        return this.getSave().getTemplate(id);
    }

    @Override
    public void setTemplate(ITemplateKey key, Template template) {
        this.getSave().setTemplate(key.getTemplateId(this::getFreeId), template);
        this.notifyListeners(key, template, l -> l::onTemplateUpdate);
    }

    @Override
    public boolean requestUpdate(ITemplateKey key) {
        return false;
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key) {
        UUID id = this.getId(key);
        Template template = this.getSave().getTemplate(id);
        this.notifyListeners(key, template, l -> l::onTemplateUpdateSend);
        PacketHandler.getSplitManager().send((Object)new SplitPacketUpdateTemplate(id, template), PacketDistributor.ALL.noArg());
        return true;
    }

    @Override
    public void registerUpdateListener(ITemplateProvider.IUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    @Override
    public void removeUpdateListener(ITemplateProvider.IUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    @Override
    public UUID getId(ITemplateKey key) {
        return key.getTemplateId(this::getFreeId);
    }

    public boolean requestRemoteUpdate(ITemplateKey key, ServerPlayerEntity playerEntity) {
        return this.requestRemoteUpdate(key, PacketDistributor.PLAYER.with(() -> playerEntity));
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key, PacketDistributor.PacketTarget target) {
        UUID id = this.getId(key);
        Template template = this.getSave().getTemplate(id);
        PacketHandler.getSplitManager().send((Object)new SplitPacketUpdateTemplate(id, template), target);
        return true;
    }

    @Override
    public boolean requestUpdate(ITemplateKey key, PacketDistributor.PacketTarget target) {
        UUID id = this.getId(key);
        PacketHandler.HANDLER.send(target, (Object)new PacketRequestTemplate(id));
        return true;
    }

    public void onRemoteIdAllocated(UUID allocated) {
        this.getSave().getTemplate(allocated);
    }

    private UUID getFreeId() {
        UUID freeId = this.getSave().getFreeUUID();
        return freeId;
    }

    private void notifyListeners(ITemplateKey key, Template template, Function<ITemplateProvider.IUpdateListener, TriConsumer<ITemplateProvider, ITemplateKey, Template>> function) {
        for (ITemplateProvider.IUpdateListener listener : this.updateListeners) {
            try {
                function.apply(listener).accept((Object)this, (Object)key, (Object)template);
            }
            catch (Exception e) {
                BuildingGadgets.LOG.error("Update listener threw an exception!", (Throwable)e);
            }
        }
    }
}

