/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.direwolf20.buildinggadgets.client.renderer.EffectBlockTER;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.tilesupport.ITileDataFactory;
import com.direwolf20.buildinggadgets.common.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.inventory.handle.IHandleProvider;
import com.direwolf20.buildinggadgets.common.inventory.handle.IObjectHandle;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.registry.ImmutableOrderedRegistry;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.registry.OurContainers;
import com.direwolf20.buildinggadgets.common.registry.OurItems;
import com.direwolf20.buildinggadgets.common.registry.TopologicalRegistryBuilder;
import com.direwolf20.buildinggadgets.common.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.tiles.EffectBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registries {
    public static ItemGroup creativeTab = new ItemGroup("buildinggadgets"){

        public ItemStack func_78016_d() {
            ItemStack stack = new ItemStack((IItemProvider)OurItems.gadgetBuilding);
            stack.func_196082_o().func_74774_a("creative", (byte)0);
            return stack;
        }
    };
    private static TopologicalRegistryBuilder<ITileDataFactory> tileDataFactoryBuilder = TopologicalRegistryBuilder.create();
    private static TopologicalRegistryBuilder<IHandleProvider> handleProviderBuilder = TopologicalRegistryBuilder.create();
    private static IForgeRegistry<ITileDataSerializer> tileDataSerializers = null;
    private static IForgeRegistry<IUniqueObjectSerializer> uniqueObjectSerializers = null;
    private static ImmutableOrderedRegistry<ITileDataFactory> tileDataFactories = null;
    private static ImmutableOrderedRegistry<IHandleProvider> handleProviders = null;

    private Registries() {
    }

    public static IForgeRegistry<IUniqueObjectSerializer> getUniqueObjectSerializers() {
        Preconditions.checkState((uniqueObjectSerializers != null ? 1 : 0) != 0, (Object)"Attempted to retrieve UniqueObjectSerializerRegistry before registries were created!");
        return uniqueObjectSerializers;
    }

    public static void setup() {
        OurItems.setup();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientRegistry.bindTileEntityRenderer(EffectBlockTileEntity.TYPE, EffectBlockTER::new));
    }

    public static void clientSetup() {
        OurContainers.registerContainerScreens();
        OurBlocks.constructionBlock.initColorHandler(Minecraft.func_71410_x().func_184125_al());
    }

    public static void onCreateRegistries() {
        BuildingGadgets.LOG.trace("Creating ForgeRegistries");
        tileDataSerializers = new RegistryBuilder().setType(ITileDataSerializer.class).setName(Reference.TileDataSerializerReference.REGISTRY_ID_TILE_DATA_SERIALIZER).create();
        uniqueObjectSerializers = new RegistryBuilder().setType(IUniqueObjectSerializer.class).setName(Reference.UniqueObjectSerializerReference.REGISTRY_ID_UNIQUE_OBJECT_SERIALIZER).create();
        BuildingGadgets.LOG.trace("Finished Creating ForgeRegistries");
    }

    @SubscribeEvent
    public static void registerTileDataSerializers(RegistryEvent.Register<ITileDataSerializer> event) {
        BuildingGadgets.LOG.trace("Registering TemplateItem Serializers");
        event.getRegistry().register((IForgeRegistryEntry)SerialisationSupport.dummyDataSerializer());
        event.getRegistry().register((IForgeRegistryEntry)SerialisationSupport.nbtTileDataSerializer());
        BuildingGadgets.LOG.trace("Finished Registering TemplateItem Serializers");
    }

    @SubscribeEvent
    public static void registerUniqueObjectSerializers(RegistryEvent.Register<IUniqueObjectSerializer> event) {
        BuildingGadgets.LOG.trace("Registering UniqueObject Serializers");
        event.getRegistry().register((IForgeRegistryEntry)SerialisationSupport.uniqueItemSerializer());
        BuildingGadgets.LOG.trace("Finished Registering UniqueObject Serializers");
    }

    public static void createOrderedRegistries() {
        BuildingGadgets.LOG.trace("Creating Ordered Registries");
        Preconditions.checkState((tileDataFactoryBuilder != null ? 1 : 0) != 0, (Object)"Cannot create Ordered Registries twice!");
        tileDataFactories = tileDataFactoryBuilder.build();
        tileDataFactoryBuilder = null;
        handleProviders = handleProviderBuilder.build();
        handleProviderBuilder = null;
        BuildingGadgets.LOG.trace("Finished Creating Ordered Registries");
    }

    public static boolean handleIMC(InterModComms.IMCMessage message) {
        BuildingGadgets.LOG.debug("Received IMC message using Method {} from {}.", (Object)message.getMethod(), (Object)message.getSenderModId());
        if (message.getMethod().equals("imc_tile_data_factory")) {
            BuildingGadgets.LOG.debug("Recognized ITileDataFactory registration message. Registering.");
            Preconditions.checkState((tileDataFactoryBuilder != null ? 1 : 0) != 0, (Object)"Attempted to register ITileDataFactory, after the Registry has been built!");
            TopologicalRegistryBuilder builder = (TopologicalRegistryBuilder)((Supplier)message.getMessageSupplier().get()).get();
            tileDataFactoryBuilder.merge(builder);
            BuildingGadgets.LOG.trace("Registered {} from {} to the ITileDataFactory registry.", (Object)builder, (Object)message.getSenderModId());
            return true;
        }
        if (message.getMethod().equals("imc_handle_provider")) {
            BuildingGadgets.LOG.debug("Recognized IHandleProvider registration message. Registering.");
            Preconditions.checkState((handleProviderBuilder != null ? 1 : 0) != 0, (Object)"Attempted to register IHandleProvider, after the Registry has been built!");
            TopologicalRegistryBuilder builder = (TopologicalRegistryBuilder)((Supplier)message.getMessageSupplier().get()).get();
            handleProviderBuilder.merge(builder);
            BuildingGadgets.LOG.trace("Registered {} from {} to the IHandleProvider registry.", (Object)builder, (Object)message.getSenderModId());
            return true;
        }
        return false;
    }

    private static void addDefaultOrdered() {
        tileDataFactoryBuilder.addMarker(Reference.MARKER_BEFORE_RL).addMarker(Reference.MARKER_AFTER_RL).addValue(Reference.TileDataFactoryReference.DATA_PROVIDER_FACTORY_RL, TileSupport.dataProviderFactory()).addDependency(Reference.MARKER_AFTER_RL, Reference.TileDataFactoryReference.DATA_PROVIDER_FACTORY_RL).addDependency(Reference.MARKER_BEFORE_RL, Reference.MARKER_AFTER_RL);
        handleProviderBuilder.addMarker(Reference.MARKER_BEFORE_RL).addMarker(Reference.MARKER_AFTER_RL).addDependency(Reference.MARKER_BEFORE_RL, Reference.MARKER_AFTER_RL);
    }

    static {
        Registries.addDefaultOrdered();
    }

    public static final class HandleProvider {
        private HandleProvider() {
        }

        public static ImmutableOrderedRegistry<IHandleProvider> getHandleProviders() {
            Preconditions.checkState((tileDataFactories != null ? 1 : 0) != 0, (Object)"Attempted to retrieve HandleProviderRegistry before it was created!");
            return handleProviders;
        }

        public static boolean indexCapProvider(ICapabilityProvider provider, Map<Class<?>, Map<Object, List<IObjectHandle<?>>>> indexMap) {
            HashSet evaluatedClasses = new HashSet();
            boolean indexed = false;
            for (IHandleProvider handleProvider : HandleProvider.getHandleProviders().getValuesInOrder()) {
                indexed |= handleProvider.index(provider, indexMap, evaluatedClasses);
            }
            return indexed;
        }
    }

    public static final class TileEntityData {
        private TileEntityData() {
        }

        public static ImmutableOrderedRegistry<ITileDataFactory> getTileDataFactories() {
            Preconditions.checkState((tileDataFactories != null ? 1 : 0) != 0, (Object)"Attempted to retrieve TileDataFactoryRegistry before it was created!");
            return tileDataFactories;
        }

        public static IForgeRegistry<ITileDataSerializer> getTileDataSerializers() {
            Preconditions.checkState((tileDataSerializers != null ? 1 : 0) != 0, (Object)"Attempted to retrieve TileDataSerializerRegistry before registries were created!");
            return tileDataSerializers;
        }
    }
}

