/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.split;

import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.split.PacketDecoder;
import com.direwolf20.buildinggadgets.common.network.split.PacketEncoder;
import com.direwolf20.buildinggadgets.common.network.split.SplitPacket;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public final class PacketSplitManager {
    public static final int SPLIT_BORDER = 30000;
    private int id;
    private final Map<Class<?>, PacketSplitHandler<?>> classToHandlerMap = new IdentityHashMap();
    private final Int2ObjectMap<PacketSplitHandler<?>> idToHandlerMap = new Int2ObjectOpenHashMap();

    public <MSG> void registerSplitPacket(Class<MSG> msgClass, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler) {
        PacketEncoder<MSG> splitEncoder = new PacketEncoder<MSG>(encoder, this.id);
        PacketDecoder<MSG> splitDecoder = new PacketDecoder<MSG>(decoder);
        PacketSplitHandler splitHandler = new PacketSplitHandler(splitEncoder, splitDecoder, handler);
        this.classToHandlerMap.put(msgClass, splitHandler);
        this.idToHandlerMap.put(this.id++, splitHandler);
    }

    public void sendTo(Object message, ServerPlayerEntity player) {
        this.send(message, (SplitPacket packet) -> PacketHandler.sendTo(packet, player));
    }

    public void sendToServer(Object message) {
        this.send(message, PacketHandler::sendToServer);
    }

    public void send(Object message, PacketDistributor.PacketTarget target) {
        this.send(message, (SplitPacket packet) -> PacketHandler.HANDLER.send(target, packet));
    }

    private void send(Object message, Consumer<SplitPacket> packetConsumer) {
        PacketSplitHandler<?> handler = this.classToHandlerMap.get(message.getClass());
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)("Cannot send unknown packet " + message + "!"));
        ((PacketSplitHandler)handler).splitPackets(message, packetConsumer);
    }

    public void encode(SplitPacket msg, PacketBuffer buf) {
        msg.writeTo(buf);
    }

    public SplitPacket decode(PacketBuffer buf) {
        return SplitPacket.readFrom(buf);
    }

    public void handle(SplitPacket msg, Supplier<NetworkEvent.Context> ctx) {
        PacketSplitHandler handler = (PacketSplitHandler)this.idToHandlerMap.get(msg.getId());
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)("Cannot handler packet with unknown id " + msg.getId() + "!"));
        handler.handleSplit(msg, ctx);
    }

    private static final class PacketSplitHandler<MSG> {
        private final PacketEncoder<MSG> encoder;
        private final PacketDecoder<MSG> decoder;
        private final BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler;

        private PacketSplitHandler(PacketEncoder<MSG> encoder, PacketDecoder<MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.handler = handler;
        }

        private void handleSplit(SplitPacket msg, Supplier<NetworkEvent.Context> ctx) {
            Optional<MSG> msgOpt = this.decoder.decode(msg);
            msgOpt.ifPresent(packet -> {
                this.handler.accept(packet, ctx);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }

        private void splitPackets(MSG msg, Consumer<SplitPacket> consumer) {
            this.encoder.encode(msg).forEach(consumer);
        }
    }
}

