/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.pastes;

import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.GenericPasteContainer;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ConstructionPasteContainer
extends GenericPasteContainer {
    private IntSupplier maxCapacity;

    public ConstructionPasteContainer(Item.Properties builder, IntSupplier maxCapacity) {
        super(builder);
        this.maxCapacity = maxCapacity;
        this.func_185043_a(Reference.PROPERTY_OVERRIDE_LEVEL, (stack, world, entity) -> {
            float percent = (float)ConstructionPasteContainer.getPasteAmount(stack) / (float)this.maxCapacity.getAsInt();
            return (float)MathHelper.func_76141_d((float)(percent * 4.0f)) / 4.0f;
        });
    }

    @Override
    public void setPasteCount(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("amount", amount);
    }

    @Override
    public int getPasteCount(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("amount");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        player.func_184598_c(hand);
        PlayerInventory inv = player.field_71071_by;
        if (!world.field_72995_K) {
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) continue;
                InventoryHelper.addPasteToContainer(player, itemStack);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add(TooltipTranslation.PASTECONTAINER_AMOUNT.componentTranslation(this.getPasteCount(stack)).func_150255_a(Styles.WHITE));
    }

    @Override
    public int getMaxCapacity() {
        return this.maxCapacity.getAsInt();
    }
}

