/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class InventoryWrapper
implements IInventory {
    @Nonnull
    private final IItemHandlerModifiable handler;
    @Nonnull
    private final Predicate<PlayerEntity> usablePredicate;
    @Nonnull
    private final Runnable markDirtyCallback;

    public InventoryWrapper(@Nonnull IItemHandlerModifiable handler) {
        this(handler, null, null);
    }

    public InventoryWrapper(@Nonnull IItemHandlerModifiable handler, @Nullable Predicate<PlayerEntity> usableByPlayerPredicate, @Nullable Runnable markDirtyCallback) {
        this.handler = Objects.requireNonNull(handler, "Cannot construct an InventoryWrapper without an Inventory to wrap.");
        this.usablePredicate = usableByPlayerPredicate != null ? usableByPlayerPredicate : playerEntity -> true;
        this.markDirtyCallback = markDirtyCallback != null ? markDirtyCallback : () -> {};
    }

    public int func_70302_i_() {
        return this.handler.getSlots();
    }

    public boolean func_191420_l() {
        return this.func_70302_i_() <= 0;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return this.handler.getStackInSlot(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.handler.extractItem(index, count, false);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return this.handler.extractItem(index, this.func_70301_a(index).func_190916_E(), false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.handler.setStackInSlot(index, stack);
    }

    public void func_70296_d() {
        this.markDirtyCallback.run();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.usablePredicate.test(player);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }
}

