/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.inventory.materials.objects;

import com.direwolf20.buildinggadgets.common.inventory.handle.IObjectHandle;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObjectSerializer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IUniqueObject<T> {
    public Class<T> getIndexClass();

    public T getIndexObject();

    public boolean matches(ItemStack var1);

    public ItemStack insertInto(ItemStack var1, int var2);

    default public boolean preferStackInsert() {
        return this.getIndexClass() == Item.class;
    }

    default public Optional<ItemStack> tryCreateInsertStack(Map<Class<?>, Map<Object, List<IObjectHandle<?>>>> index, int count) {
        return Optional.of(this.createStack(count));
    }

    default public ItemStack createStack() {
        return this.createStack(1);
    }

    default public ResourceLocation getObjectRegistryName() {
        T indexObj = this.getIndexObject();
        if (indexObj instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)indexObj).getRegistryName();
        }
        return new ResourceLocation("buildinggadgets", this.getIndexClass().getSimpleName());
    }

    public ItemStack createStack(int var1);

    public IUniqueObjectSerializer getSerializer();
}

