/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building;

import com.direwolf20.buildinggadgets.common.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.spliterator.SpliteratorBackedPeekingIterator;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.PeekingIterator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;

public final class Region
implements IPositionPlacementSequence,
Serializable {
    private static final Region ZERO = new Region(BlockPos.field_177959_e);
    private static final long serialVersionUID = 8391481277782374853L;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public static Region singleZero() {
        return ZERO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder enclosingBuilder() {
        return Region.enclosingBuilder(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static Builder enclosingBuilder(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new Builder(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static Region deserializeFrom(CompoundNBT tag) {
        return new Region(tag.func_74762_e("minX"), tag.func_74762_e("minY"), tag.func_74762_e("minZ"), tag.func_74762_e("maxX"), tag.func_74762_e("maxY"), tag.func_74762_e("maxZ"));
    }

    public Region(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public Region(Vec3i vertex) {
        this(vertex, vertex);
    }

    public Region(Vec3i min, Vec3i max) {
        this(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public Region translate(int x, int y, int z) {
        return new Region(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region translate(Vec3i direction) {
        return this.translate(direction.func_177958_n(), direction.func_177956_o(), direction.func_177952_p());
    }

    public Region inverseTranslate(Vec3i direction) {
        return this.translate(-direction.func_177958_n(), -direction.func_177956_o(), -direction.func_177952_p());
    }

    public Region grow(int x, int y, int z) {
        return new Region(this.minX, this.minY, this.minZ, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region grow(int size) {
        return this.grow(size, size, size);
    }

    public Region shrink(int x, int y, int z) {
        return this.grow(-x, -y, -z);
    }

    public Region shrink(int size) {
        return this.grow(-size);
    }

    public Region expand(int x, int y, int z) {
        return new Region(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region expand(Vec3i vec) {
        return this.expand(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public Region expand(int size) {
        return this.expand(size, size, size);
    }

    public Region collapse(int x, int y, int z) {
        return this.expand(-x, -y, -z);
    }

    public Region collapse(Vec3i vec) {
        return this.collapse(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public Region collapse(int size) {
        return this.expand(-size);
    }

    public Region intersect(Region other) {
        int minX = Math.max(this.minX, other.minX);
        int minY = Math.max(this.minY, other.minY);
        int minZ = Math.max(this.minZ, other.minZ);
        int maxX = Math.min(this.maxX, other.maxX);
        int maxY = Math.min(this.maxY, other.maxY);
        int maxZ = Math.min(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region union(Region other) {
        int minX = Math.min(this.minX, other.minX);
        int minY = Math.min(this.minY, other.minY);
        int minZ = Math.min(this.minZ, other.minZ);
        int maxX = Math.max(this.maxX, other.maxX);
        int maxY = Math.max(this.maxY, other.maxY);
        int maxZ = Math.max(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public int getXSize() {
        return Math.abs(this.maxX - this.minX) + 1;
    }

    public int getYSize() {
        return Math.abs(this.maxY - this.minY) + 1;
    }

    public int getZSize() {
        return Math.abs(this.maxZ - this.minZ) + 1;
    }

    public int size() {
        return this.getXSize() * this.getYSize() * this.getZSize();
    }

    public boolean containsX(int x) {
        return x >= this.minX && x <= this.maxX;
    }

    public boolean containsY(int y) {
        return y >= this.minY && y <= this.maxY;
    }

    public boolean containsZ(int z) {
        return z >= this.minZ && z <= this.maxZ;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.contains(x, y, z);
    }

    public boolean contains(int x, int y, int z) {
        return this.containsX(x) && this.containsY(y) && this.containsZ(z);
    }

    public boolean contains(Vec3i vec) {
        return this.mayContain(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public boolean intersectsWith(Region other) {
        return this.maxX >= other.minX && this.minX <= other.maxX && this.maxZ >= other.minZ && this.minZ <= other.maxZ && this.maxY >= other.minY && this.minY <= other.maxY;
    }

    @Override
    @Deprecated
    public Region copy() {
        return new Region(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @Override
    public Region getBoundingBox() {
        return this;
    }

    @Override
    public PeekingIterator<BlockPos> iterator() {
        return new SpliteratorBackedPeekingIterator<BlockPos>(this.spliterator());
    }

    @Override
    public Spliterator<BlockPos> spliterator() {
        return new RegionSpliterator(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minX", this.minX).add("minY", this.minY).add("minZ", this.minZ).add("maxX", this.maxX).add("maxY", this.maxY).add("maxZ", this.maxZ).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.minX == region.minX && this.minY == region.minY && this.minZ == region.minZ && this.maxX == region.maxX && this.maxY == region.maxY && this.maxZ == region.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public ImmutableSortedSet<ChunkPos> getUnloadedChunks(IWorldReader reader) {
        ImmutableSortedSet.Builder posBuilder = ImmutableSortedSet.orderedBy(Comparator.comparing(ChunkPos::func_180334_c).thenComparing(ChunkPos::func_180333_d));
        for (int i = this.minX; i <= this.maxX; i += 16) {
            for (int j = this.minZ; j <= this.maxZ; j += 16) {
                if (reader.func_217354_b(i >> 4, j >> 4)) continue;
                posBuilder.add((Object)new ChunkPos(i >> 4, j >> 4));
            }
        }
        for (int j = this.minZ; j <= this.maxZ; j += 16) {
            if (reader.func_217354_b(this.maxX >> 4, j >> 4)) continue;
            posBuilder.add((Object)new ChunkPos(this.maxX >> 4, j >> 4));
        }
        if (!reader.func_217354_b(this.maxX >> 4, this.maxZ >> 4)) {
            posBuilder.add((Object)new ChunkPos(this.maxX >> 4, this.maxZ >> 4));
        }
        return posBuilder.build();
    }

    public CompoundNBT serialize() {
        return this.serializeTo(new CompoundNBT());
    }

    public CompoundNBT serializeTo(CompoundNBT tag) {
        tag.func_74768_a("minX", this.minX);
        tag.func_74768_a("minY", this.minY);
        tag.func_74768_a("minZ", this.minZ);
        tag.func_74768_a("maxX", this.maxX);
        tag.func_74768_a("maxY", this.maxY);
        tag.func_74768_a("maxZ", this.maxZ);
        return tag;
    }

    private static class RegionSpliterator
    implements Spliterator<BlockPos> {
        private int minX;
        private int minY;
        private int minZ;
        private int maxX;
        private int maxY;
        private int maxZ;
        private int nextPosX;
        private int nextPosY;
        private int nextPosZ;
        private boolean allowYZSplit;

        private RegionSpliterator(Region region) {
            this(region.getMinX(), region.getMinY(), region.getMinZ(), region.getMaxX(), region.getMaxY(), region.getMaxZ());
        }

        private RegionSpliterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this(minX, minY, minZ, maxX, maxY, maxZ, minX, minY, minZ, true);
        }

        private RegionSpliterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int posX, int posY, int posZ, boolean allowYZSplit) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.nextPosX = posX;
            this.nextPosY = posY;
            this.nextPosZ = posZ;
            this.allowYZSplit = allowYZSplit;
        }

        @Override
        public boolean tryAdvance(Consumer<? super BlockPos> action) {
            if (this.isXOverflowed()) {
                return false;
            }
            this.allowYZSplit = false;
            BlockPos pos = new BlockPos(this.nextPosX, this.nextPosY, this.nextPosZ);
            ++this.nextPosZ;
            if (this.isZOverflowed()) {
                this.nextPosZ = this.minZ;
                ++this.nextPosY;
            } else {
                action.accept((BlockPos)pos);
                return true;
            }
            if (this.isYOverflowed()) {
                this.nextPosY = this.minY;
                ++this.nextPosX;
            } else {
                action.accept((BlockPos)pos);
                return true;
            }
            action.accept((BlockPos)pos);
            return true;
        }

        @Override
        public Spliterator<BlockPos> trySplit() {
            int oldMinX = this.minX;
            int oldMinY = this.minY;
            int oldMinZ = this.minZ;
            int oldPosX = this.nextPosX;
            int oldPosY = this.nextPosY;
            int oldPosZ = this.nextPosZ;
            if (this.maxX > this.minX) {
                this.minX = (this.maxX - this.minX + 1) / 2 + this.minX + 1;
                this.resetPos();
                return new RegionSpliterator(oldMinX, oldMinY, oldMinZ, this.minX - 1, this.maxY, this.maxZ, oldPosX, oldPosY, oldPosZ, this.allowYZSplit);
            }
            if (this.maxY > this.minY && this.allowYZSplit) {
                this.minY = (this.maxY - this.minY + 1) / 2 + this.minY + 1;
                this.resetPos();
                return new RegionSpliterator(oldMinX, oldMinY, oldMinZ, this.maxX, this.minY - 1, this.maxZ, oldPosX, oldPosY, oldPosZ, this.allowYZSplit);
            }
            if (this.maxZ > this.minZ && this.allowYZSplit) {
                this.minZ = (this.maxZ - this.minZ + 1) / 2 + this.minZ + 1;
                this.resetPos();
                return new RegionSpliterator(oldMinX, oldMinY, oldMinZ, this.maxX, this.maxY, this.minZ - 1, oldPosX, oldPosY, oldPosZ, this.allowYZSplit);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return (Math.abs((long)this.maxX - (long)this.nextPosX) + 1L) * (Math.abs((long)this.maxY - (long)this.nextPosY) + 1L) * Math.abs((long)this.maxZ - (long)this.nextPosZ + 1L);
        }

        @Override
        public int characteristics() {
            return 17749;
        }

        @Override
        public Comparator<? super BlockPos> getComparator() {
            return CommonUtils.POSITION_COMPARATOR;
        }

        private boolean isXOverflowed() {
            return this.nextPosX > this.maxX;
        }

        private boolean isYOverflowed() {
            return this.nextPosY > this.maxY;
        }

        private boolean isZOverflowed() {
            return this.nextPosZ > this.maxZ;
        }

        private void resetPos() {
            this.nextPosX = this.minX;
            this.nextPosY = this.minY;
            this.nextPosZ = this.minZ;
        }
    }

    public static class Builder {
        private int minX;
        private int minY;
        private int minZ;
        private int maxX;
        private int maxY;
        private int maxZ;

        private Builder() {
            this(0, 0, 0, 0, 0, 0);
        }

        public Builder(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public Builder encloseAll(Iterable<? extends Vec3i> iterable) {
            for (Vec3i vec3i : iterable) {
                this.enclose(vec3i);
            }
            return this;
        }

        public Builder enclose(Region region) {
            this.enclose((Vec3i)region.getMin());
            this.enclose((Vec3i)region.getMax());
            return this;
        }

        public Builder enclose(Vec3i vec) {
            return this.enclose(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
        }

        public Builder enclose(int x, int y, int z) {
            this.encloseX(x);
            this.encloseY(y);
            this.encloseZ(z);
            return this;
        }

        public Builder encloseX(int x) {
            this.minX = Math.min(x, this.minX);
            this.maxX = Math.max(x, this.maxX);
            return this;
        }

        public Builder encloseY(int y) {
            this.minY = Math.min(y, this.minY);
            this.maxY = Math.max(y, this.maxY);
            return this;
        }

        public Builder encloseZ(int z) {
            this.minZ = Math.min(z, this.minZ);
            this.maxZ = Math.max(z, this.maxZ);
            return this;
        }

        public Region build() {
            return new Region(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

