/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building;

import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public final class PlacementTarget {
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final BlockData data;

    public static PlacementTarget deserialize(CompoundNBT nbt, boolean persisted) {
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos"));
        BlockData data = BlockData.deserialize(nbt.func_74775_l("data"), persisted);
        return new PlacementTarget(pos, data);
    }

    public PlacementTarget(@Nonnull BlockPos pos, @Nonnull BlockData data) {
        this.pos = Objects.requireNonNull(pos);
        this.data = Objects.requireNonNull(data);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockData getData() {
        return this.data;
    }

    public boolean placeIn(IBuildContext context) {
        return this.data.placeIn(context, this.pos);
    }

    public PlacementTarget mirror(Mirror mirror) {
        return new PlacementTarget(this.pos, this.data.mirror(mirror));
    }

    public PlacementTarget rotate(Rotation rotation) {
        return new PlacementTarget(this.getPos(), this.getData().rotate(rotation));
    }

    public MaterialList getRequiredMaterials(IBuildContext context, @Nullable RayTraceResult target) {
        return this.getData().getRequiredItems(context, target, this.getPos());
    }

    public CompoundNBT serialize(boolean persisted) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("data", (INBT)this.data.serialize(persisted));
        compound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        return compound;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pos", (Object)this.pos).add("data", (Object)this.data).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlacementTarget)) {
            return false;
        }
        PlacementTarget that = (PlacementTarget)o;
        if (!this.getPos().equals((Object)that.getPos())) {
            return false;
        }
        return this.getData().equals(that.getData());
    }

    public int hashCode() {
        int result = this.getPos().hashCode();
        result = 31 * result + this.getData().hashCode();
        return result;
    }
}

