/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.CopyGUI;
import com.direwolf20.buildinggadgets.client.screen.DestructionGUI;
import com.direwolf20.buildinggadgets.client.screen.PasteGUI;
import com.direwolf20.buildinggadgets.client.screen.materiallist.MaterialListGUI;
import com.direwolf20.buildinggadgets.common.items.TemplateItem;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import java.awt.Color;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public enum GuiMod {
    COPY(GadgetCopyPaste::getGadget, stack -> () -> new CopyGUI((ItemStack)stack)),
    PASTE(GadgetCopyPaste::getGadget, stack -> () -> new PasteGUI()),
    DESTRUCTION(GadgetDestruction::getGadget, stack -> () -> new DestructionGUI((ItemStack)stack)),
    MATERIAL_LIST(TemplateItem::getHeldCapItem, stack -> () -> new MaterialListGUI((ItemStack)stack));

    private Function<PlayerEntity, ItemStack> stackReader;
    private Function<ItemStack, Supplier<? extends Screen>> clientScreenProvider;

    private GuiMod(Function<PlayerEntity, ItemStack> stackReader, Function<ItemStack, Supplier<? extends Screen>> clientScreenProvider) {
        this.stackReader = stackReader;
        this.clientScreenProvider = clientScreenProvider;
    }

    public static Screen openScreen(Minecraft minecraft, Screen screen) {
        return screen;
    }

    public boolean openScreen(PlayerEntity player) {
        if (this.clientScreenProvider == null) {
            return false;
        }
        ItemStack stack = this.stackReader.apply(player);
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        Screen screen = this.clientScreenProvider.apply(stack).get();
        Minecraft.func_71410_x().func_147108_a(screen);
        return screen == null;
    }

    public static String getLangKeySingle(String name) {
        return LangUtil.getLangKey("gui", "single", name);
    }

    public static Color getColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

