/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModResources;

public class BlockDoorSensorSwitch
extends BlockSwitch {
    public BlockDoorSensorSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public TileEntityDoorSensorSwitch getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityDoorSensorSwitch)) {
            return null;
        }
        return (TileEntityDoorSensorSwitch)te;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityDoorSensorSwitch(ModContent.TET_DOORSENSOR_SWITCH);
    }

    public static class TileEntityDoorSensorSwitch
    extends BlockSwitch.TileEntitySwitch
    implements ITickableTileEntity {
        private int update_timer_ = 0;

        public TileEntityDoorSensorSwitch(TileEntityType<?> te_type) {
            super(te_type);
        }

        public TileEntityDoorSensorSwitch() {
            super(ModContent.TET_DOORSENSOR_SWITCH);
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = 4;
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (state == null || !(state.func_177230_c() instanceof BlockDoorSensorSwitch)) {
                return;
            }
            BlockDoorSensorSwitch block = (BlockDoorSensorSwitch)state.func_177230_c();
            Vec3d door_vec = new Vec3d(((Direction)state.func_177229_b((IProperty)RsDirectedBlock.FACING)).func_176730_m());
            AxisAlignedBB volume = new AxisAlignedBB(this.func_174877_v().func_177977_b()).func_186662_g(0.4).func_191194_a(door_vec.func_186678_a(-0.5));
            boolean active = false;
            List hits = this.field_145850_b.func_217357_a(PlayerEntity.class, volume);
            if (hits.size() > 0) {
                Vec3d door_pos = new Vec3d((Vec3i)this.func_174877_v().func_177972_a((Direction)state.func_177229_b((IProperty)RsDirectedBlock.FACING)).func_177977_b()).func_72441_c(0.5, 0.5, 0.5);
                for (Entity e : hits) {
                    Vec3d rel_position;
                    double cos_a2;
                    Vec3d look_vec;
                    double cos_a1;
                    if (Math.abs(e.func_70040_Z().func_82617_b()) > 0.7 || (cos_a1 = (look_vec = new Vec3d(e.func_70040_Z().func_82615_a(), 0.0, e.func_70040_Z().func_82616_c())).func_72430_b(door_vec)) < 0.5 || (cos_a2 = look_vec.func_72430_b(rel_position = new Vec3d(e.func_213303_ch().func_82615_a() - door_pos.func_82615_a(), 0.0, e.func_213303_ch().func_82616_c() - door_pos.func_82616_c()).func_72432_b())) > -0.8) continue;
                    active = true;
                    break;
                }
            }
            if (active) {
                if (!((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue()) {
                    block.onSwitchActivated(this.field_145850_b, this.field_174879_c, state, null, null);
                    this.on_timer_reset(12);
                } else {
                    this.on_timer_reset(12);
                    this.reschedule_block_tick();
                }
            }
        }
    }
}

