/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.IRsNeighbourInteractionSensitive;
import wile.rsgauges.detail.BlockCategories;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModColors;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.Networking;
import wile.rsgauges.detail.OptionalRecipeCondition;
import wile.rsgauges.detail.OverlayEventHandler;

@Mod(value="rsgauges")
public class ModRsGauges {
    public static final String MODID = "rsgauges";
    public static final String MODNAME = "Gauges and Switches";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ISidedProxy proxy = (ISidedProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final ItemGroup ITEMGROUP = new ItemGroup("tabrsgauges"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModContent.INDUSTRIAL_SMALL_LEVER);
        }
    };

    public ModRsGauges() {
        ModAuxiliaries.logGitVersion(MODNAME);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, PlayerInteractEvent.class, ForgeEvents::onPlayerInteract);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfig.COMMON_CONFIG_SPEC);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    public static final class ServerProxy
    implements ISidedProxy {
        @Override
        @Nullable
        public PlayerEntity getPlayerClientSide() {
            return null;
        }

        @Override
        @Nullable
        public World getWorldClientSide() {
            return null;
        }

        @Override
        @Nullable
        public Minecraft mc() {
            return null;
        }
    }

    public static final class ClientProxy
    implements ISidedProxy {
        @Override
        @Nullable
        public PlayerEntity getPlayerClientSide() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        @Override
        @Nullable
        public World getWorldClientSide() {
            return Minecraft.func_71410_x().field_71441_e;
        }

        @Override
        @Nullable
        public Minecraft mc() {
            return Minecraft.func_71410_x();
        }
    }

    public static interface ISidedProxy {
        @Nullable
        default public PlayerEntity getPlayerClientSide() {
            return null;
        }

        @Nullable
        default public World getWorldClientSide() {
            return null;
        }

        @Nullable
        default public Minecraft mc() {
            return null;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static final void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static final void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.registerItems(event);
        }

        @SubscribeEvent
        public static final void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            ModContent.registerTileEntities(event);
        }

        @SubscribeEvent
        public static final void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        }

        @SubscribeEvent
        public static final void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        }

        @SubscribeEvent
        public static final void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
            ModResources.registerSoundEvents(event);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static final void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
            ModColors.registerBlockColourHandlers(event);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static final void registerItemColourHandlers(ColorHandlerEvent.Item event) {
            ModColors.registerItemColourHandlers(event);
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            ModConfig.apply();
            LOGGER.info("Registering recipe condition processor ...");
            CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
            LOGGER.info("Init networking, overlay handling, content processors ...");
            Networking.init();
            ModContent.processRegisteredContent();
            BlockCategories.update();
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            OverlayEventHandler.register();
            ModContent.processContentClientSide(event);
        }

        @SubscribeEvent
        public static void onSendImc(InterModEnqueueEvent event) {
        }

        @SubscribeEvent
        public static void onRecvImc(InterModProcessEvent event) {
        }

        @SubscribeEvent
        public static void onServerStarting(FMLServerStartingEvent event) {
        }

        @SubscribeEvent
        public static void onConfigLoad(ModConfig.Loading event) {
            ModConfig.onLoad(event.getConfig());
        }

        @SubscribeEvent
        public static void onConfigChanged(ModConfig.Reloading event) {
            ModConfig.onFileChange(event.getConfig());
        }

        public static void onPlayerInteract(PlayerInteractEvent event) {
            boolean is_lclick;
            World world = event.getWorld();
            if (world.field_72995_K) {
                return;
            }
            boolean is_rclick = event instanceof PlayerInteractEvent.RightClickBlock && event.getHand() == Hand.MAIN_HAND;
            boolean bl = is_lclick = event instanceof PlayerInteractEvent.LeftClickBlock && event.getHand() == Hand.MAIN_HAND && event.getFace() != Direction.DOWN;
            if (!is_rclick && !is_lclick) {
                return;
            }
            BlockPos fromPos = event.getPos();
            for (Direction facing : Direction.values()) {
                if (event.getFace() == facing) continue;
                BlockPos pos = fromPos.func_177972_a(facing);
                BlockState state = event.getWorld().func_180495_p(pos);
                if (!(state.func_177230_c() instanceof IRsNeighbourInteractionSensitive) || !((IRsNeighbourInteractionSensitive)state.func_177230_c()).onNeighborBlockPlayerInteraction(world, pos, state, fromPos, event.getEntityLiving(), event.getHand(), is_lclick)) continue;
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }
}

