/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.BiomeBOP;
import biomesoplenty.common.biome.BiomeRegistry;
import biomesoplenty.common.biome.nether.AshenInfernoBiome;
import biomesoplenty.common.biome.nether.UndergardenBiome;
import biomesoplenty.common.biome.nether.VisceralHeapBiome;
import biomesoplenty.common.biome.overworld.AlpsBiome;
import biomesoplenty.common.biome.overworld.AlpsFoothillsBiome;
import biomesoplenty.common.biome.overworld.BayouBiome;
import biomesoplenty.common.biome.overworld.BogBiome;
import biomesoplenty.common.biome.overworld.BorealForestBiome;
import biomesoplenty.common.biome.overworld.BrushlandBiome;
import biomesoplenty.common.biome.overworld.ChaparralBiome;
import biomesoplenty.common.biome.overworld.CherryBlossomGroveBiome;
import biomesoplenty.common.biome.overworld.ColdDesertBiome;
import biomesoplenty.common.biome.overworld.ConiferousForestBiome;
import biomesoplenty.common.biome.overworld.DeadForestBiome;
import biomesoplenty.common.biome.overworld.FirClearingBiome;
import biomesoplenty.common.biome.overworld.FloodplainBiome;
import biomesoplenty.common.biome.overworld.FlowerMeadowBiome;
import biomesoplenty.common.biome.overworld.FungalJungleBiome;
import biomesoplenty.common.biome.overworld.GhostForestBiome;
import biomesoplenty.common.biome.overworld.GrasslandBiome;
import biomesoplenty.common.biome.overworld.GravelBeachBiome;
import biomesoplenty.common.biome.overworld.GroveBiome;
import biomesoplenty.common.biome.overworld.HighlandBiome;
import biomesoplenty.common.biome.overworld.HighlandMoorBiome;
import biomesoplenty.common.biome.overworld.LavenderFieldBiome;
import biomesoplenty.common.biome.overworld.LushGrasslandBiome;
import biomesoplenty.common.biome.overworld.LushSwampBiome;
import biomesoplenty.common.biome.overworld.MangroveBiome;
import biomesoplenty.common.biome.overworld.MapleWoodsBiome;
import biomesoplenty.common.biome.overworld.MarshBiome;
import biomesoplenty.common.biome.overworld.MeadowBiome;
import biomesoplenty.common.biome.overworld.MireBiome;
import biomesoplenty.common.biome.overworld.MysticGroveBiome;
import biomesoplenty.common.biome.overworld.OasisBiome;
import biomesoplenty.common.biome.overworld.OminousWoodsBiome;
import biomesoplenty.common.biome.overworld.OrchardBiome;
import biomesoplenty.common.biome.overworld.OriginBeachBiome;
import biomesoplenty.common.biome.overworld.OriginHillsBiome;
import biomesoplenty.common.biome.overworld.OutbackBiome;
import biomesoplenty.common.biome.overworld.OvergrownCliffsBiome;
import biomesoplenty.common.biome.overworld.PastureBiome;
import biomesoplenty.common.biome.overworld.PoppyFieldBiome;
import biomesoplenty.common.biome.overworld.PrairieBiome;
import biomesoplenty.common.biome.overworld.PumpkinPatchBiome;
import biomesoplenty.common.biome.overworld.RainbowValleyBiome;
import biomesoplenty.common.biome.overworld.RainforestBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestEdgeBiome;
import biomesoplenty.common.biome.overworld.ScrublandBiome;
import biomesoplenty.common.biome.overworld.SeasonalForestBiome;
import biomesoplenty.common.biome.overworld.ShieldBiome;
import biomesoplenty.common.biome.overworld.ShrublandBiome;
import biomesoplenty.common.biome.overworld.SilkgladeBiome;
import biomesoplenty.common.biome.overworld.SnowyConiferousForestBiome;
import biomesoplenty.common.biome.overworld.SnowyFirClearingBiome;
import biomesoplenty.common.biome.overworld.SnowyForestBiome;
import biomesoplenty.common.biome.overworld.SteppeBiome;
import biomesoplenty.common.biome.overworld.TemperateRainforestBiome;
import biomesoplenty.common.biome.overworld.TemperateRainforestHillsBiome;
import biomesoplenty.common.biome.overworld.TropicalRainforestBiome;
import biomesoplenty.common.biome.overworld.TropicsBiome;
import biomesoplenty.common.biome.overworld.TundraBiome;
import biomesoplenty.common.biome.overworld.VolcanoBiome;
import biomesoplenty.common.biome.overworld.VolcanoEdgeBiome;
import biomesoplenty.common.biome.overworld.WastelandBiome;
import biomesoplenty.common.biome.overworld.WetlandBiome;
import biomesoplenty.common.biome.overworld.WhiteBeachBiome;
import biomesoplenty.common.biome.overworld.WoodlandBiome;
import biomesoplenty.common.biome.overworld.XericShrublandBiome;
import biomesoplenty.common.world.WorldTypeBOP;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static WorldTypeBOP worldType;
    public static Multimap<Integer, WeightedSubBiome> subBiomes;
    public static List<Integer> islandBiomeIds;

    public static void setup() {
        worldType = new WorldTypeBOP();
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerTechnicalBiome(new GravelBeachBiome(), "gravel_beach");
        ModBiomes.registerTechnicalBiome(new OriginBeachBiome(), "origin_beach");
        ModBiomes.registerTechnicalBiome(new WhiteBeachBiome(), "white_beach");
        ModBiomes.registerTechnicalBiome(new AlpsFoothillsBiome(), "alps_foothills");
        ModBiomes.registerTechnicalBiome(new RedwoodForestEdgeBiome(), "redwood_forest_edge");
        ModBiomes.registerTechnicalBiome(new VolcanoEdgeBiome(), "volcano_edge");
        ModBiomes.registerTechnicalBiome(new OrchardBiome(), "orchard");
        BiomeRegistry.configureTechnicalBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.TECHNICAL_BIOME);
        ModBiomes.registerBiome(new MangroveBiome(), "mangrove");
        ModBiomes.registerBiome(new AlpsBiome(), "alps");
        ModBiomes.registerBiome(new BayouBiome(), "bayou");
        ModBiomes.registerBiome(new BogBiome(), "bog");
        ModBiomes.registerBiome(new BorealForestBiome(), "boreal_forest");
        ModBiomes.registerBiome(new BrushlandBiome(), "brushland");
        ModBiomes.registerBiome(new ChaparralBiome(), "chaparral");
        ModBiomes.registerBiome(new CherryBlossomGroveBiome(), "cherry_blossom_grove");
        ModBiomes.registerBiome(new ColdDesertBiome(), "cold_desert");
        ModBiomes.registerBiome(new ConiferousForestBiome(), "coniferous_forest");
        ModBiomes.registerBiome(new DeadForestBiome(), "dead_forest");
        ModBiomes.registerBiome(new FirClearingBiome(), "fir_clearing");
        ModBiomes.registerBiome(new FloodplainBiome(), "floodplain");
        ModBiomes.registerBiome(new FlowerMeadowBiome(), "flower_meadow");
        ModBiomes.registerBiome(new FungalJungleBiome(), "fungal_jungle");
        ModBiomes.registerBiome(new GhostForestBiome(), "ghost_forest");
        ModBiomes.registerBiome(new GrasslandBiome(), "grassland");
        ModBiomes.registerBiome(new GroveBiome(), "grove");
        ModBiomes.registerBiome(new HighlandBiome(), "highland");
        ModBiomes.registerBiome(new HighlandMoorBiome(), "highland_moor");
        ModBiomes.registerBiome(new LavenderFieldBiome(), "lavender_field");
        ModBiomes.registerBiome(new LushGrasslandBiome(), "lush_grassland");
        ModBiomes.registerBiome(new LushSwampBiome(), "lush_swamp");
        ModBiomes.registerBiome(new MapleWoodsBiome(), "maple_woods");
        ModBiomes.registerBiome(new MarshBiome(), "marsh");
        ModBiomes.registerBiome(new MeadowBiome(), "meadow");
        ModBiomes.registerBiome(new MireBiome(), "mire");
        ModBiomes.registerBiome(new MysticGroveBiome(), "mystic_grove");
        ModBiomes.registerBiome(new OasisBiome(), "oasis");
        ModBiomes.registerBiome(new OminousWoodsBiome(), "ominous_woods");
        ModBiomes.registerBiome(new OriginHillsBiome(), "origin_hills");
        ModBiomes.registerBiome(new OutbackBiome(), "outback");
        ModBiomes.registerBiome(new OvergrownCliffsBiome(), "overgrown_cliffs");
        ModBiomes.registerBiome(new PastureBiome(), "pasture");
        ModBiomes.registerBiome(new PoppyFieldBiome(), "poppy_field");
        ModBiomes.registerBiome(new PrairieBiome(), "prairie");
        ModBiomes.registerBiome(new PumpkinPatchBiome(), "pumpkin_patch");
        ModBiomes.registerBiome(new RainbowValleyBiome(), "rainbow_valley");
        ModBiomes.registerBiome(new RainforestBiome(), "rainforest");
        ModBiomes.registerBiome(new RedwoodForestBiome(), "redwood_forest");
        ModBiomes.registerBiome(new ScrublandBiome(), "scrubland");
        ModBiomes.registerBiome(new SeasonalForestBiome(), "seasonal_forest");
        ModBiomes.registerBiome(new ShieldBiome(), "shield");
        ModBiomes.registerBiome(new ShrublandBiome(), "shrubland");
        ModBiomes.registerBiome(new SilkgladeBiome(), "silkglade");
        ModBiomes.registerBiome(new SnowyConiferousForestBiome(), "snowy_coniferous_forest");
        ModBiomes.registerBiome(new SnowyFirClearingBiome(), "snowy_fir_clearing");
        ModBiomes.registerBiome(new SnowyForestBiome(), "snowy_forest");
        ModBiomes.registerBiome(new SteppeBiome(), "steppe");
        ModBiomes.registerBiome(new TemperateRainforestBiome(), "temperate_rainforest");
        ModBiomes.registerBiome(new TemperateRainforestHillsBiome(), "temperate_rainforest_hills");
        ModBiomes.registerBiome(new TropicalRainforestBiome(), "tropical_rainforest");
        ModBiomes.registerBiome(new TropicsBiome(), "tropics");
        ModBiomes.registerBiome(new TundraBiome(), "tundra");
        ModBiomes.registerBiome(new VolcanoBiome(), "volcano");
        ModBiomes.registerBiome(new WastelandBiome(), "wasteland");
        ModBiomes.registerBiome(new WetlandBiome(), "wetland");
        ModBiomes.registerBiome(new WoodlandBiome(), "woodland");
        ModBiomes.registerBiome(new XericShrublandBiome(), "xeric_shrubland");
        ModBiomes.registerBiome(new AshenInfernoBiome(), "ashen_inferno");
        ModBiomes.registerBiome(new UndergardenBiome(), "undergarden");
        ModBiomes.registerBiome(new VisceralHeapBiome(), "visceral_heap");
        BiomeRegistry.configureStandardBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.STANDARD_BIOME);
        ModBiomes.registerSubBiome(Biomes.field_76769_d, BOPBiomes.oasis, 0.1f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.brushland, BOPBiomes.xeric_shrubland, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.coniferous_forest, BOPBiomes.fir_clearing, 0.38f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.highland, BOPBiomes.highland_moor, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.meadow, BOPBiomes.flower_meadow, 0.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.prairie, BOPBiomes.pasture, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.seasonal_forest, BOPBiomes.pumpkin_patch, 0.45f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.snowy_coniferous_forest, BOPBiomes.snowy_fir_clearing, 0.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.temperate_rainforest, BOPBiomes.temperate_rainforest_hills, 0.8f, 100);
        BiomeRegistry.configureSubBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.SUB_BIOME);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.COOL_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.DRY_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.WET_TEMPERATE, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.WARM_TEMPERATE, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.MEDITERRANEAN, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.SAVANNA, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_valley, BOPClimates.WET_TEMPERATE, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_valley, BOPClimates.WARM_TEMPERATE, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_valley, BOPClimates.MEDITERRANEAN, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.SUBTROPICAL, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.TROPICAL, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.HOT_DESERT, 50);
        BiomeRegistry.configureIslandBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.ISLAND_BIOME);
        ModBiomes.registerVanillaBiome(Biomes.field_76774_n, BOPClimates.ICE_CAP, 10);
        ModBiomes.registerVanillaBiome(Biomes.field_76770_e, BOPClimates.TUNDRA, 7);
        ModBiomes.registerVanillaBiome(Biomes.field_150584_S, BOPClimates.TUNDRA, 10);
        ModBiomes.registerVanillaBiome(Biomes.field_76768_g, BOPClimates.WET_BOREAL, 10);
        ModBiomes.registerVanillaBiome(Biomes.field_150578_U, BOPClimates.DRY_BOREAL, 5);
        ModBiomes.registerVanillaBiome(Biomes.field_150585_R, BOPClimates.WET_TEMPERATE, 5);
        ModBiomes.registerVanillaBiome(Biomes.field_76780_h, BOPClimates.WET_TEMPERATE, 7);
        ModBiomes.registerVanillaBiome(Biomes.field_150583_P, BOPClimates.DRY_TEMPERATE, 7);
        ModBiomes.registerVanillaBiome(Biomes.field_76767_f, BOPClimates.COOL_TEMPERATE, 10);
        ModBiomes.registerVanillaBiome(Biomes.field_76772_c, BOPClimates.WARM_TEMPERATE, 10);
        ModBiomes.registerVanillaBiome(Biomes.field_76782_w, BOPClimates.TROPICAL, 15);
        ModBiomes.registerVanillaBiome(Biomes.field_150588_X, BOPClimates.SAVANNA, 10);
        ModBiomes.registerVanillaBiome(Biomes.field_76769_d, BOPClimates.HOT_DESERT, 15);
        ModBiomes.registerVanillaBiome(Biomes.field_150608_ab, BOPClimates.HOT_DESERT, 10);
        ModBiomes.registerVanillaBiome(Biomes.field_150607_aa, BOPClimates.HOT_DESERT, 3);
        ModBiomes.registerVanillaBiome(Biomes.field_76778_j, BOPClimates.NETHER, 10);
        BiomeRegistry.configureVanillaBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.VANILLA_BIOME);
        ModBiomes.registerBiomeDictionaryTags();
        ModBiomes.registerVillagerTypes();
    }

    private static void registerBiomeDictionaryTags() {
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps_foothills, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bayou, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bog, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.boreal_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.brushland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.chaparral, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cherry_blossom_grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cold_desert, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coniferous_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fir_clearing, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.floodplain, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WATER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.flower_meadow, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fungal_jungle, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ghost_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grassland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.gravel_beach, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland_moor, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lavender_field, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MAGICAL);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_grassland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_swamp, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mangrove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.maple_woods, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.marsh, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.meadow, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mire, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mystic_grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.oasis, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ominous_woods, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.orchard, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.origin_beach, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.origin_hills, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.outback, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.overgrown_cliffs, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.pasture, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.poppy_field, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.prairie, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.pumpkin_patch, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainbow_valley, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainforest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest_edge, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.scrubland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.seasonal_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shield, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shrubland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.silkglade, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_coniferous_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_fir_clearing, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.steppe, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.temperate_rainforest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.temperate_rainforest_hills, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropical_rainforest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropics, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tundra, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcano, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcano_edge, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wasteland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wetland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.white_beach, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.woodland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.xeric_shrubland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ashen_inferno, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.undergarden, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.visceral_heap, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT);
    }

    private static void registerVillagerTypes() {
        ModBiomes.registerVillagerType(BOPBiomes.alps, IVillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.alps_foothills, IVillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.bayou, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.bog, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.boreal_forest, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.brushland, IVillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.chaparral, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.cherry_blossom_grove, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.cold_desert, IVillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.coniferous_forest, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.dead_forest, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.fir_clearing, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.floodplain, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.flower_meadow, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.fungal_jungle, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.ghost_forest, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.grassland, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.gravel_beach, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.grove, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.highland, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.highland_moor, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.lavender_field, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.lush_grassland, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.lush_swamp, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.mangrove, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.maple_woods, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.marsh, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.meadow, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.mire, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.mystic_grove, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.oasis, IVillagerType.field_221173_a);
        ModBiomes.registerVillagerType(BOPBiomes.ominous_woods, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.orchard, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.origin_beach, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.origin_hills, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.outback, IVillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.overgrown_cliffs, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.pasture, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.poppy_field, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.prairie, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.pumpkin_patch, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.rainbow_valley, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.rainforest, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.redwood_forest, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.redwood_forest_edge, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.scrubland, IVillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.seasonal_forest, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.shield, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.shrubland, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.silkglade, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_coniferous_forest, IVillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_fir_clearing, IVillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_forest, IVillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.steppe, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.temperate_rainforest, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.temperate_rainforest_hills, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.tropical_rainforest, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.tropics, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.tundra, IVillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.volcano, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.volcano_edge, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.wasteland, IVillagerType.field_221173_a);
        ModBiomes.registerVillagerType(BOPBiomes.wetland, IVillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.white_beach, IVillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.woodland, IVillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.xeric_shrubland, IVillagerType.field_221173_a);
    }

    private static void registerBiomeToDictionary(Optional<Biome> biome, BiomeDictionary.Type ... types) {
        if (biome.isPresent()) {
            BiomeDictionary.addTypes((Biome)biome.get(), (BiomeDictionary.Type[])types);
        }
    }

    private static void registerVillagerType(Optional<Biome> biome, IVillagerType type) {
        if (biome.isPresent()) {
            IVillagerType.field_221180_h.put(biome.get(), type);
        }
    }

    public static void registerBiome(BiomeBOP biome, String name) {
        BiomeRegistry.deferStandardRegistration(biome, name);
    }

    public static void registerTechnicalBiome(BiomeBOP biome, String name) {
        BiomeRegistry.deferTechnicalBiomeRegistration(biome, name);
    }

    public static void registerSubBiome(Biome parent, Optional<Biome> child, float rarity, int weight) {
        ModBiomes.registerSubBiome(Optional.of(parent), child, rarity, weight);
    }

    public static void registerSubBiome(Optional<Biome> parent, Optional<Biome> child, float rarity, int weight) {
        if (!parent.isPresent()) {
            return;
        }
        if (!child.isPresent()) {
            return;
        }
        BiomeRegistry.deferSubBiomeRegistration(parent.get(), child.get(), weight, rarity);
    }

    public static void registerIslandBiome(Biome biome, BOPClimates climate, int weight) {
        BiomeRegistry.deferIslandBiomeRegistration(biome, climate, weight);
    }

    public static void registerIslandBiome(Optional<Biome> biome, BOPClimates climate, int weight) {
        if (!biome.isPresent()) {
            return;
        }
        ModBiomes.registerIslandBiome(biome.get(), climate, weight);
    }

    private static void registerVanillaBiome(Biome biome, BOPClimates climate, int weight) {
        BiomeRegistry.deferVanillaBiomeRegistration(biome, climate, weight);
    }

    static {
        subBiomes = HashMultimap.create();
        islandBiomeIds = Lists.newArrayList();
    }

    public static class WeightedSubBiome {
        public final Biome biome;
        public final float rarity;
        public final int weight;

        public WeightedSubBiome(Biome biome, float rarity, int weight) {
            this.biome = biome;
            this.rarity = rarity;
            this.weight = weight;
        }
    }
}

