/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;

public class RedwoodTreeFeature
extends TreeFeatureBase {
    private int trunkWidth = 1;

    protected RedwoodTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.trunkWidth = trunkWidth;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = this.trunkWidth * (height - y) / height + 1;
            int trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(IWorld world, Random rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.nextInt(2) != 0)) continue;
                this.placeLeaves(world, pos.func_177982_a(x, 0, z), changedLeaves, boundingBox);
            }
        }
    }

    public void generateBranch(IWorld world, Random rand, BlockPos pos, Direction direction, int length, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        Direction.Axis axis = direction.func_176740_k();
        Direction sideways = direction.func_176746_e();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.func_177967_a(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.func_177967_a(sideways, j), changedLeaves, boundingBox);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.func_177984_a(), changedLeaves, boundingBox);
            this.placeLeaves(world, pos1.func_177984_a().func_177967_a(sideways, -1), changedLeaves, boundingBox);
            this.placeLeaves(world, pos1.func_177984_a().func_177967_a(sideways, 1), changedLeaves, boundingBox);
            this.placeLog(world, pos1, axis, changedLogs, boundingBox);
        }
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random random, BlockPos startPos, MutableBoundingBox boundingBox) {
        int trunkEnd;
        int trunkStart;
        int trunkWidth;
        int baseHeight;
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        for (int x = 0; x <= this.trunkWidth - 1; ++x) {
            for (int z = 0; z <= this.trunkWidth - 1; ++z) {
                if (this.placeOn.matches(world, startPos.func_177982_a(x, 0, z))) continue;
                return false;
            }
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f)));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace(world, startPos.func_177984_a(), baseHeight, height)) {
            return false;
        }
        BlockPos pos = startPos.func_177981_b(height);
        this.placeLeaves(world, pos, changedLeaves, boundingBox);
        pos.func_177977_b();
        for (int i = 0; i < leavesHeight; ++i) {
            trunkWidth = this.trunkWidth * i / height + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 4, 2 + (leavesHeight - i)), 4);
            if (radius == 0) {
                this.placeLeaves(world, pos, changedLeaves, boundingBox);
            } else if (radius < 2) {
                this.generateLeafLayer(world, random, pos, radius, trunkStart, trunkEnd, changedLeaves, boundingBox);
            } else {
                this.generateBranch(world, random, pos.func_177982_a(trunkStart, 0, trunkStart), Direction.NORTH, radius, changedLogs, changedLeaves, boundingBox);
                this.generateBranch(world, random, pos.func_177982_a(trunkEnd, 0, trunkStart), Direction.EAST, radius, changedLogs, changedLeaves, boundingBox);
                this.generateBranch(world, random, pos.func_177982_a(trunkEnd, 0, trunkEnd), Direction.SOUTH, radius, changedLogs, changedLeaves, boundingBox);
                this.generateBranch(world, random, pos.func_177982_a(trunkStart, 0, trunkEnd), Direction.WEST, radius, changedLogs, changedLeaves, boundingBox);
            }
            pos = pos.func_177977_b();
        }
        for (int y = 0; y < height - 1; ++y) {
            trunkWidth = this.trunkWidth * (height - y) / height + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            if (trunkWidth < 1) {
                trunkStart = 0;
                trunkEnd = 0;
            }
            for (int x = trunkStart; x <= trunkEnd; ++x) {
                for (int z = trunkStart; z <= trunkEnd; ++z) {
                    this.placeLog(world, startPos.func_177982_a(x, y, z), changedLogs, boundingBox);
                }
            }
        }
        return true;
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, RedwoodTreeFeature> {
        protected int trunkWidth;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder() {
            this.minHeight = 10;
            this.maxHeight = 30;
            this.log = BOPBlocks.redwood_log.func_176223_P();
            this.leaves = BOPBlocks.redwood_leaves.func_176223_P();
            this.vine = Blocks.field_150395_bd.func_176223_P();
            this.trunkWidth = 1;
        }

        @Override
        public RedwoodTreeFeature create() {
            return new RedwoodTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth);
        }
    }
}

