/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;

public class BulbTreeFeature
extends TreeFeatureBase {
    protected BulbTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    public boolean setCocoa(IWorld world, BlockPos pos, Direction side) {
        BlockState cocoaState = (BlockState)Blocks.field_150375_by.func_176223_P().func_206870_a((IProperty)DirectionalBlock.field_176387_N, (Comparable)side);
        if (this.replace.matches(world, pos)) {
            this.func_202278_a((IWorldWriter)world, pos, cocoaState);
            return true;
        }
        return false;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateBranch(IWorld world, Random random, BlockPos pos, Direction direction, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        Direction sideways = direction.func_176746_e();
        this.placeLeaves(world, pos.func_177967_a(direction, 1), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177984_a().func_177967_a(direction, 1), changedLeaves, boundingBox);
        if (random.nextInt(3) > 0) {
            this.placeLeaves(world, pos.func_177984_a().func_177967_a(direction, 1).func_177967_a(sideways, 1), changedLeaves, boundingBox);
        }
    }

    public void generateLeafLayer(IWorld world, Random random, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.generateBranch(world, random, pos, direction, changedLeaves, boundingBox);
        }
        this.placeLog(world, pos, changedLogs, boundingBox);
        this.placeLog(world, pos.func_177984_a(), changedLogs, boundingBox);
    }

    public void generateTop(IWorld world, Random random, BlockPos pos, int topHeight, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        for (int y = 0; y < topHeight; ++y) {
            int radius = topHeight - 1 - y;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) >= radius && Math.abs(z) >= radius && random.nextInt(2) != 0) continue;
                    this.placeLeaves(world, pos.func_177982_a(x, y, z), changedLeaves, boundingBox);
                }
            }
            if (y < topHeight - 1) {
                this.placeLog(world, pos.func_177982_a(0, y, 0), changedLogs, boundingBox);
                continue;
            }
            this.placeLeaves(world, pos.func_177982_a(0, y, 0), changedLeaves, boundingBox);
        }
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random random, BlockPos startPos, MutableBoundingBox boundingBox) {
        int i;
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        if (height < 6) {
            return false;
        }
        int topHeight = 3;
        int heightMinusTop = height - topHeight;
        int numBranches = heightMinusTop / 5;
        int baseHeight = heightMinusTop - numBranches * 2;
        BlockPos pos = startPos.func_177984_a();
        if (!this.checkSpace(world, pos, baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.placeLog(world, pos, changedLogs, boundingBox);
            pos = pos.func_177984_a();
        }
        for (i = 0; i < numBranches; ++i) {
            this.generateLeafLayer(world, random, pos, changedLogs, changedLeaves, boundingBox);
            pos = pos.func_177981_b(2);
        }
        this.generateTop(world, random, pos, topHeight, changedLogs, changedLeaves, boundingBox);
        this.addVines(world, random, startPos, baseHeight, height, 3, 10);
        return true;
    }

    protected void addVines(IWorld world, Random rand, BlockPos startPos, int baseHeight, int height, int leavesRadius, int generationAttempts) {
        if (this.vine == null) {
            return;
        }
        block0: for (int i = 0; i < generationAttempts; ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            Direction back = direction.func_176734_d();
            Direction sideways = direction.func_176746_e();
            BlockPos pos = startPos.func_177981_b(GeneratorUtil.nextIntBetween(rand, baseHeight + 1, height)).func_177967_a(direction, leavesRadius + 1).func_177967_a(sideways, GeneratorUtil.nextIntBetween(rand, -leavesRadius, leavesRadius));
            for (int l = 0; l < leavesRadius; ++l) {
                if (world.func_180495_p(pos.func_177967_a(back, 1 + l)) != this.leaves) continue;
                this.setVine(world, rand, pos.func_177967_a(back, l), back, 4);
                continue block0;
            }
        }
    }

    protected void addCocoa(IWorld world, Random rand, BlockPos startPos, int baseHeight, int generationAttempts) {
        for (int i = 0; i < generationAttempts; ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            Direction back = direction.func_176734_d();
            BlockPos pos = startPos.func_177981_b(GeneratorUtil.nextIntBetween(rand, 1, baseHeight)).func_177967_a(direction, 1);
            this.setCocoa(world, pos, back);
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, BulbTreeFeature> {
        public Builder() {
            this.minHeight = 6;
            this.maxHeight = 12;
        }

        @Override
        public BulbTreeFeature create() {
            return new BulbTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

