/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.feature.BigBrownMushroomFeature;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;

public class BOPBigBrownMushroomFeature
extends BigBrownMushroomFeature {
    public BOPBigBrownMushroomFeature(Function<Dynamic<?>, ? extends BigMushroomFeatureConfig> deserializer) {
        super(deserializer);
    }

    protected void func_227210_a_(IWorld world, Random random, BlockPos pos, BigMushroomFeatureConfig config, int height, BlockPos.Mutable mutablePos) {
        for (int i = 0; i < height; ++i) {
            mutablePos.func_189533_g((Vec3i)pos).func_189534_c(Direction.UP, i);
            if (!world.func_180495_p((BlockPos)mutablePos).canBeReplacedByLeaves((IWorldReader)world, (BlockPos)mutablePos)) continue;
            this.func_202278_a((IWorldWriter)world, (BlockPos)mutablePos, config.field_227273_b_.func_225574_a_(random, pos));
        }
    }

    protected void func_225564_a_(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutablePos, BigMushroomFeatureConfig config) {
        int radius = config.field_227274_c_;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                boolean northOrSouthEdge;
                boolean westEdge = x == -radius;
                boolean eastEdge = x == radius;
                boolean northEdge = z == -radius;
                boolean southEdge = z == radius;
                boolean eastOrWestEdge = westEdge || eastEdge;
                boolean bl = northOrSouthEdge = northEdge || southEdge;
                if (eastOrWestEdge && northOrSouthEdge) continue;
                mutablePos.func_189533_g((Vec3i)pos).func_196234_d(x, height, z);
                if (!world.func_180495_p((BlockPos)mutablePos).canBeReplacedByLeaves((IWorldReader)world, (BlockPos)mutablePos)) continue;
                boolean westFace = westEdge || northOrSouthEdge && x == 1 - radius;
                boolean eastFace = eastEdge || northOrSouthEdge && x == radius - 1;
                boolean northFace = northEdge || eastOrWestEdge && z == 1 - radius;
                boolean southFace = southEdge || eastOrWestEdge && z == radius - 1;
                this.func_202278_a((IWorldWriter)world, (BlockPos)mutablePos, (BlockState)((BlockState)((BlockState)((BlockState)config.field_227272_a_.func_225574_a_(random, pos).func_206870_a((IProperty)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(westFace))).func_206870_a((IProperty)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(eastFace))).func_206870_a((IProperty)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(northFace))).func_206870_a((IProperty)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(southFace)));
            }
        }
    }

    protected boolean func_227209_a_(IWorld world, BlockPos pos, int height, BlockPos.Mutable mutablePos, BigMushroomFeatureConfig config) {
        int i = pos.func_177956_o();
        if (i >= 1 && i + height + 1 < world.getMaxHeight()) {
            Block groundBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (!BOPBigBrownMushroomFeature.func_227250_b_((Block)groundBlock) && groundBlock != Blocks.field_150424_aL && groundBlock != Blocks.field_150425_aM) {
                return false;
            }
            for (int y = 0; y <= height; ++y) {
                int radius = this.func_225563_a_(-1, -1, config.field_227274_c_, y);
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockState obstructingState = world.func_180495_p((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z));
                        if (obstructingState.isAir((IBlockReader)world, (BlockPos)mutablePos) || obstructingState.func_203425_a(BlockTags.field_206952_E)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

