/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.util.FontAwesomeIcons;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetImage;
import com.mojang.blaze3d.systems.RenderSystem;

public class WidgetFontAwesome
extends WidgetImage {
    FontAwesomeIcons icon;
    IconSize size;

    public WidgetFontAwesome(FontAwesomeIcons icon, IconSize iconSize) {
        super(iconSize == IconSize.TINY ? icon.get(false) : icon.get(true));
        this.icon = icon;
        this.size = iconSize;
        this.setTextureSize(icon.getWidth() * 2, icon.getHeight() * 2);
        this.setSize(iconSize.getWidgetWidth(icon), iconSize.getWidgetHeight(icon));
    }

    public WidgetFontAwesome setIcon(FontAwesomeIcons icon) {
        this.icon = icon;
        this.image = this.size == IconSize.TINY ? icon.get(false) : icon.get(true);
        return this;
    }

    public WidgetFontAwesome setSize(IconSize size) {
        this.size = size;
        this.image = size == IconSize.TINY ? this.icon.get(false) : this.icon.get(true);
        return this;
    }

    @Override
    protected void actuallyDraw() {
        RenderSystem.scalef((float)this.size.sizeModifier, (float)this.size.sizeModifier, (float)this.size.sizeModifier);
        GUIHelper.drawModalRectWithCustomSizedTexture(0, 0, 0.0f, 0.0f, this.width * this.size.sizeFactor, this.height * this.size.sizeFactor, this.textureWidth, this.textureHeight);
    }

    public static enum IconSize {
        TINY(0.25f, 4),
        MEDIUM(0.5f, 2),
        LARGE(1.0f, 1);

        float sizeModifier;
        int sizeFactor;

        private IconSize(float sizeModifier, int sizeFactor) {
            this.sizeModifier = sizeModifier;
            this.sizeFactor = sizeFactor;
        }

        public int getWidgetWidth(FontAwesomeIcons icon) {
            return (int)((float)icon.getWidth() * this.sizeModifier * 2.0f);
        }

        public int getWidgetHeight(FontAwesomeIcons icon) {
            return (int)((float)icon.getHeight() * this.sizeModifier * 2.0f);
        }
    }
}

