/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.event.CharTypedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyPressedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyReleasedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseMoveEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseReleasedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseScrollEvent;
import com.davenonymous.libnonymous.gui.framework.event.UpdateScreenEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class WidgetScreen
extends Screen {
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;
    protected ResourceLocation id;

    protected WidgetScreen(ITextComponent title) {
        super(title);
    }

    protected abstract GUI createGUI();

    public GUI getOrCreateGui() {
        if (this.gui == null) {
            this.gui = this.createGUI();
            this.gui.setVisible(true);
        }
        return this.gui;
    }

    public void tick() {
        super.tick();
        this.getOrCreateGui().fireEvent(new UpdateScreenEvent());
        this.resetMousePositions();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.getOrCreateGui().fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.getOrCreateGui().fireEvent(new MouseReleasedEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.getOrCreateGui().fireEvent(new KeyReleasedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.func_223281_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int code) {
        if (this.getOrCreateGui().fireEvent(new CharTypedEvent(chr, code)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.charTyped(chr, code);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getOrCreateGui().fireEvent(new KeyPressedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        if (this.getOrCreateGui().fireEvent(new MouseScrollEvent(mouseX, mouseY, scrollAmount)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseScrolled(mouseX, mouseY, scrollAmount);
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.getOrCreateGui().fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        this.getOrCreateGui().drawGUI(this);
        this.getOrCreateGui().drawTooltips(this, mouseX, mouseY);
        RenderHelper.func_74518_a();
    }

    public void renderBackground() {
        super.renderBackground();
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

