/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.config.types;

import com.davenonymous.libnonymous.gui.config.types.SettingListEntry;
import com.davenonymous.libnonymous.gui.framework.ColorHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetFontAwesome;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetInputField;
import com.davenonymous.libnonymous.utils.Logz;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;

public class EnumSettingListEntry
extends SettingListEntry {
    WidgetInputField inputField;

    public EnumSettingListEntry(String optionKey, String comment, ForgeConfigSpec.ConfigValue value, Object defaultValue, int columnWidth) {
        super(optionKey, comment, value, defaultValue, columnWidth);
    }

    @Override
    public void fillPanel(int entryHeight) {
        Class<?> enumClazz;
        if (this.value.get() != null) {
            enumClazz = this.value.get().getClass();
        } else if (this.defaultValue != null) {
            enumClazz = this.defaultValue.getClass();
        } else {
            this.addUnsupportedRow(entryHeight);
            Logz.warn("Enum values without default setting or empty value are not supported. We don't know the type otherwise!", new Object[0]);
            return;
        }
        String val = this.value.get().toString();
        this.setSize(this.columnWidth, entryHeight + 18);
        this.inputField = new WidgetInputField();
        this.inputField.setValue(val);
        this.inputField.setDimensions(5, entryHeight - 3, this.columnWidth - 26, 14);
        this.add(this.inputField);
        WidgetFontAwesome save = new WidgetFontAwesome(SAVE_ICON, WidgetFontAwesome.IconSize.MEDIUM);
        save.setColor(ColorHelper.COLOR_DISABLED);
        save.setPosition(this.columnWidth - 16, entryHeight - 4);
        save.addListener(MouseEnterEvent.class, (event, widget) -> {
            save.setColor(ColorHelper.COLOR_ENABLED);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        save.addListener(MouseExitEvent.class, (event, widget) -> {
            save.setColor(ColorHelper.COLOR_DISABLED);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        save.addListener(MouseClickEvent.class, (event, widget) -> {
            String inputValue = ((String)this.inputField.getValue()).toUpperCase();
            try {
                Object enumVal = Enum.valueOf(enumClazz, inputValue);
                if (enumVal == null) {
                    return WidgetEventResult.CONTINUE_PROCESSING;
                }
                this.value.set(enumVal);
                this.value.save();
                this.updateDefaultIconState();
                this.hideErrorIcon();
            }
            catch (IllegalArgumentException e) {
                this.showErrorIcon(I18n.func_135052_a((String)"libnonymous.config.error.invalid_enum", (Object[])new Object[0]));
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.add(save);
    }

    @Override
    public void setValueInInputField(Object defaultValue) {
        if (defaultValue == null) {
            this.inputField.setValue("");
        } else {
            this.inputField.setValue(defaultValue.toString());
        }
    }
}

