/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.blocks;

import com.chaosthedude.endermail.blocks.te.PackageTileEntity;
import com.chaosthedude.endermail.config.ConfigHandler;
import com.chaosthedude.endermail.entity.EnderMailmanEntity;
import com.chaosthedude.endermail.gui.ScreenWrapper;
import com.chaosthedude.endermail.items.PackageControllerItem;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import com.chaosthedude.endermail.registry.EnderMailEntities;
import com.chaosthedude.endermail.registry.EnderMailItems;
import com.chaosthedude.endermail.util.ControllerState;
import com.chaosthedude.endermail.util.ItemUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class PackageBlock
extends ContainerBlock {
    public static final String NAME = "package";
    public static final int INVENTORY_SIZE = 5;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty STAMPED = BooleanProperty.func_177716_a((String)"stamped");

    public PackageBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)STAMPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{STAMPED});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_175149_v()) {
            return ActionResultType.SUCCESS;
        }
        if (world.func_201670_d() && !this.isStamped(state) && player.func_184586_b(hand).func_77973_b() == EnderMailItems.STAMP) {
            ScreenWrapper.openStampScreen(world, player, pos);
            return ActionResultType.SUCCESS;
        }
        if (!world.func_201670_d()) {
            boolean holdingStamp = ItemUtils.isHolding(player, EnderMailItems.STAMP);
            boolean holdingPackageController = ItemUtils.isHolding(player, EnderMailItems.PACKAGE_CONTROLLER);
            if (this.isStamped(state) && player.func_184586_b(hand).func_77973_b() == EnderMailItems.PACKAGE_CONTROLLER) {
                ItemStack stack = ItemUtils.getHeldItem(player, EnderMailItems.PACKAGE_CONTROLLER);
                PackageControllerItem packageController = (PackageControllerItem)stack.func_77973_b();
                BlockPos deliveryPos = PackageBlock.getDeliveryPos(world, pos);
                String lockerID = PackageBlock.getLockerID(world, pos);
                if (deliveryPos != null) {
                    packageController.setDeliveryPos(stack, deliveryPos);
                    int distanceToDelivery = (int)Math.sqrt(pos.func_177951_i((Vec3i)deliveryPos));
                    if ((Integer)ConfigHandler.GENERAL.maxDeliveryDistance.get() > -1 && distanceToDelivery > (Integer)ConfigHandler.GENERAL.maxDeliveryDistance.get()) {
                        packageController.setState(stack, ControllerState.TOOFAR);
                        packageController.setDeliveryDistance(stack, distanceToDelivery);
                        packageController.setMaxDistance(stack, (Integer)ConfigHandler.GENERAL.maxDeliveryDistance.get());
                    } else {
                        packageController.setState(stack, ControllerState.DELIVERING);
                        EnderMailmanEntity enderMailman = new EnderMailmanEntity(EnderMailEntities.ENDER_MAILMAN_TYPE, world, pos, deliveryPos, lockerID, stack);
                        world.func_217376_c((Entity)enderMailman);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (this.isStamped(state) && (player.func_213453_ef() || player.func_184586_b(hand) == null && !holdingStamp && !holdingPackageController)) {
                PackageBlock.setState(false, world, pos);
                return ActionResultType.SUCCESS;
            }
            if (!(this.isStamped(state) || player.func_213453_ef() || holdingStamp)) {
                TileEntity te = world.func_175625_s(pos);
                if (te != null && te instanceof PackageTileEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((PackageTileEntity)te), (BlockPos)pos);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof PackageTileEntity) {
            ((PackageTileEntity)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        if (te != null && te instanceof PackageTileEntity) {
            PackageTileEntity tePackage = (PackageTileEntity)te;
            ItemStack stackPackage = new ItemStack((IItemProvider)EnderMailItems.PACKAGE);
            CompoundNBT stackTag = new CompoundNBT();
            CompoundNBT itemTag = tePackage.writeItems(new CompoundNBT());
            if (!itemTag.isEmpty()) {
                stackTag.func_218657_a("BlockEntityTag", (INBT)itemTag);
            }
            if (!stackTag.isEmpty()) {
                stackPackage.func_77982_d(stackTag);
            }
            if (tePackage.hasCustomName()) {
                stackPackage.func_200302_a(tePackage.func_145748_c_());
            }
            PackageBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stackPackage);
            world.func_175666_e(pos, state.func_177230_c());
        }
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack = super.func_185473_a(world, pos, state);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof PackageTileEntity) {
            PackageTileEntity tePackage = (PackageTileEntity)te;
            CompoundNBT stackTag = new CompoundNBT();
            CompoundNBT itemTag = tePackage.writeItems(new CompoundNBT());
            if (!itemTag.isEmpty()) {
                stackTag.func_218657_a("BlockEntityTag", (INBT)itemTag);
            }
            if (!stackTag.isEmpty()) {
                stack.func_77982_d(stackTag);
            }
            if (tePackage.hasCustomName()) {
                stack.func_200302_a(tePackage.func_145748_c_());
            }
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_190948_a(stack, world, tooltip, flag);
        if (Screen.hasShiftDown()) {
            CompoundNBT tag;
            CompoundNBT temp = stack.func_77978_p();
            if (temp != null && temp.func_150297_b("BlockEntityTag", 10) && (tag = temp.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
                NonNullList content = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)content);
                for (ItemStack contentStack : content) {
                    if (contentStack.func_190926_b()) continue;
                    ITextComponent textComponent = contentStack.func_200301_q().func_212638_h();
                    textComponent.func_150258_a(" x").func_150258_a(String.valueOf(contentStack.func_190916_E())).func_211708_a(TextFormatting.GRAY);
                    tooltip.add(textComponent);
                }
            }
        } else {
            tooltip.add(new StringTextComponent(I18n.func_135052_a((String)"string.endermail.holdShift", (Object[])new Object[0])).func_211709_a(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new PackageTileEntity();
    }

    public BlockState getStampedState() {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)STAMPED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState getRandomlyRotatedStampedState() {
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)STAMPED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FACING, (Comparable)directions[new Random().nextInt(4)]);
    }

    public boolean isStamped(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)STAMPED);
    }

    public static void stampPackage(World world, BlockPos packagePos, BlockPos deliveryPos, String lockerID) {
        PackageBlock.setState(true, world, packagePos);
        TileEntity te = world.func_175625_s(packagePos);
        if (te != null && te instanceof PackageTileEntity) {
            PackageTileEntity tePackage = (PackageTileEntity)te;
            tePackage.setDeliveryPos(deliveryPos);
            tePackage.setLockerID(lockerID);
        }
    }

    public static BlockPos getDeliveryPos(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof PackageTileEntity) {
            PackageTileEntity tePackage = (PackageTileEntity)te;
            return tePackage.getDeliveryPos();
        }
        return null;
    }

    public static String getLockerID(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof PackageTileEntity) {
            PackageTileEntity tePackage = (PackageTileEntity)te;
            return tePackage.getLockerID();
        }
        return null;
    }

    public static void setState(boolean stamped, World world, BlockPos pos) {
        BlockState iblockstate = world.func_180495_p(pos);
        TileEntity tileentity = world.func_175625_s(pos);
        world.func_180501_a(pos, (BlockState)((BlockState)EnderMailBlocks.PACKAGE.func_176223_P().func_206870_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)STAMPED, (Comparable)Boolean.valueOf(stamped)), 3);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, tileentity);
        }
    }
}

