/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.client;

import com.black_dog20.servertabinfo.client.GuiTabPage;
import com.black_dog20.servertabinfo.client.objects.IRenderable;
import com.black_dog20.servertabinfo.client.objects.Player;
import com.black_dog20.servertabinfo.utility.CompatibilityHelper;
import com.black_dog20.servertabinfo.utility.RenderHelper;
import com.black_dog20.servertabinfo.utility.TpsDimension;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomPlayerList {
    private static final Ordering<NetworkPlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private final Minecraft mc;
    public static HashMap<String, TpsDimension> playerDims = new HashMap();
    public static List<IRenderable> playerList;
    private int maxPages = 1;
    private int currentPage = 1;
    private int ticks = 0;
    private int changeTicks = 200;

    public CustomPlayerList(Minecraft mc) {
        this.mc = mc;
    }

    public boolean render(int width) {
        List<IRenderable> renderList;
        ++this.ticks;
        int y = 10;
        ClientPlayNetHandler nethandlerplayclient = this.mc.field_71439_g.field_71174_a;
        List list = ENTRY_ORDERING.sortedCopy((Iterable)nethandlerplayclient.func_175106_d());
        playerList = new ArrayList<IRenderable>();
        int hight = (int)((double)(GuiTabPage.hight - y) - (double)GuiTabPage.hight * 0.15);
        this.mc.field_71466_p.getClass();
        int itemPerPage = (int)Math.floor(hight / 9 / 2);
        for (NetworkPlayerInfo networkplayerinfo : list) {
            playerList.add(new Player(networkplayerinfo, this.mc));
        }
        this.maxPages = (int)Math.ceil((double)playerList.size() / (double)itemPerPage);
        if (this.ticks % this.changeTicks == 0) {
            this.ticks = 0;
            this.changePage();
        }
        if ((renderList = RenderHelper.getPage(this.currentPage, itemPerPage, playerList)).isEmpty()) {
            String error = I18n.func_135052_a((String)"gui.servertabinfo.errorpage1", (Object[])new Object[0]);
            CompatibilityHelper.drawCenteredStringWithShadow(this.mc, error, (float)GuiTabPage.width / 2.0f, y, -1);
            String error2 = I18n.func_135052_a((String)"gui.servertabinfo.errorpage2", (Object[])new Object[0]);
            CompatibilityHelper.drawCenteredStringWithShadow(this.mc, error2, (float)GuiTabPage.width / 2.0f, y += CompatibilityHelper.getFontRenderHeight(this.mc), -1);
        } else {
            int yy = RenderHelper.RenderObjectList(renderList, this.mc, y, width);
            String s = I18n.func_135052_a((String)"gui.servertabinfo.page", (Object[])new Object[]{this.currentPage, this.maxPages});
            int x = GuiTabPage.width / 2;
            CompatibilityHelper.drawStringWithShadow(this.mc, s, (float)x + 2.0f, yy, -1);
        }
        return true;
    }

    private void changePage() {
        this.currentPage = this.currentPage >= this.maxPages ? 1 : ++this.currentPage;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo p_compare_1_, NetworkPlayerInfo p_compare_2_) {
            ScorePlayerTeam scoreplayerteam = p_compare_1_.func_178850_i();
            ScorePlayerTeam scoreplayerteam1 = p_compare_2_.func_178850_i();
            return ComparisonChain.start().compareTrueFirst(p_compare_1_.func_178848_b() != GameType.SPECTATOR, p_compare_2_.func_178848_b() != GameType.SPECTATOR).compare((Comparable)((Object)(scoreplayerteam != null ? scoreplayerteam.func_96661_b() : "")), (Comparable)((Object)(scoreplayerteam1 != null ? scoreplayerteam1.func_96661_b() : ""))).compare((Comparable)((Object)p_compare_1_.func_178845_a().getName()), (Comparable)((Object)p_compare_2_.func_178845_a().getName())).result();
        }
    }
}

