/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ILightReader;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.flopper.tileentity.TileFlopper;

public class RenderTileEntityFlopper
extends TileEntityRenderer<TileFlopper> {
    public RenderTileEntityFlopper(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileFlopper tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            FluidStack fluid = tile.getTank().getFluid();
            RenderHelpers.renderFluidContext((FluidStack)fluid, (MatrixStack)matrixStack, () -> {
                float height = (float)fluid.getAmount() * 0.3125f / (float)tile.getTank().getCapacity() + 0.6875f;
                int brightness = Math.max(combinedLight, fluid.getFluid().getAttributes().getLuminosity(fluid));
                int l2 = brightness >> 16 & 0xFFFF;
                int i3 = brightness & 0xFFFF;
                TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)tile.getTank().getFluid(), (Direction)Direction.UP);
                Triple color = Helpers.intToRGB((int)fluid.getFluid().getAttributes().getColor((ILightReader)tile.func_145831_w(), tile.func_174877_v()));
                IVertexBuilder vb = buffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                vb.func_227888_a_(matrix, 0.125f, height, 0.125f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
                vb.func_227888_a_(matrix, 0.125f, height, 0.875f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                vb.func_227888_a_(matrix, 0.875f, height, 0.875f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                vb.func_227888_a_(matrix, 0.875f, height, 0.125f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
            });
        }
    }
}

