/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.programmer.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.modules.programmer.ProgrammerSetup;
import mcjty.rftoolscontrol.modules.programmer.blocks.ProgrammerContainer;
import mcjty.rftoolscontrol.modules.various.VariousSetup;
import mcjty.rftoolscontrol.modules.various.items.ProgramCardItem;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class ProgrammerTileEntity
extends GenericTileEntity {
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<NoDirectionItemHander> itemHandler = LazyOptional.of(() -> this.items);
    private final LazyOptional<AutomationFilterItemHander> automationItemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Programmer").containerSupplier((windowId, player) -> new ProgrammerContainer((int)windowId, (ContainerFactory)ProgrammerContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), this)).itemHandler(this.itemHandler));

    public ProgrammerTileEntity() {
        super((TileEntityType)ProgrammerSetup.PROGRAMMER_TILE.get());
        this.items.setStackInSlot(1, new ItemStack((IItemProvider)VariousSetup.PROGRAM_CARD.get()));
    }

    public NoDirectionItemHander getItems() {
        return this.items;
    }

    public void setPowerInput(int powered) {
        int p = this.powerLevel;
        super.setPowerInput(powered);
        if (p != this.powerLevel && this.powerLevel > 0) {
            ItemStack dummy = this.items.getStackInSlot(1);
            if (dummy.func_190926_b()) {
                return;
            }
            if (!dummy.func_77942_o()) {
                return;
            }
            ItemStack card = this.items.getStackInSlot(0);
            if (card.func_190926_b()) {
                return;
            }
            ProgramCardInstance instance = ProgramCardInstance.parseInstance(dummy);
            if (instance == null) {
                return;
            }
            ProgramCardItem.setCardName(card, ProgramCardItem.getCardName(dummy));
            INBT newGrid = dummy.func_77978_p().func_74781_a("grid").func_74737_b();
            card.func_77978_p().func_218657_a("grid", newGrid);
        }
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander((GenericTileEntity)this, (ContainerFactory)ProgrammerContainer.CONTAINER_FACTORY.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.automationItemHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

