/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTankFluidsReady {
    public BlockPos pos;
    public List<FluidStack> list;
    public String command;

    public PacketTankFluidsReady(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<FluidStack>(size);
            for (int i = 0; i < size; ++i) {
                FluidStack fluidStack = null;
                if (buf.readBoolean()) {
                    fluidStack = NetworkTools.readFluidStack((ByteBuf)buf);
                }
                FluidStack item = fluidStack;
                this.list.add(item);
            }
        } else {
            this.list = null;
        }
    }

    public PacketTankFluidsReady(BlockPos pos, String command, List<FluidStack> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<FluidStack>();
        this.list.addAll(list);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (FluidStack item : this.list) {
                if (item == null) {
                    buf.writeBoolean(false);
                    continue;
                }
                buf.writeBoolean(true);
                NetworkTools.writeFluidStack((ByteBuf)buf, (FluidStack)item);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(FluidStack.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }
}

