/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.router.client;

import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.router.network.PacketGetLocalChannelsRouter;
import mcjty.xnet.modules.router.network.PacketGetRemoteChannelsRouter;
import mcjty.xnet.setup.XNetMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class GuiRouter
extends GenericGuiContainer<TileEntityRouter, GenericContainer> {
    private WidgetList localChannelList;
    private WidgetList remoteChannelList;
    public static List<ControllerChannelClientInfo> fromServer_localChannels = null;
    public static List<ControllerChannelClientInfo> fromServer_remoteChannels = null;
    private boolean needsRefresh = true;
    private int listDirty;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");

    public GuiRouter(TileEntityRouter router, GenericContainer container, PlayerInventory inventory) {
        super((ModBase)XNet.instance, (GenericTileEntity)router, (Container)container, inventory, ManualHelper.create((String)"xnet:network/router"));
    }

    public void init() {
        this.window = new Window((Screen)this, this.tileEntity, XNetMessages.INSTANCE, new ResourceLocation("xnet", "gui/router.gui"));
        super.init();
        this.localChannelList = (WidgetList)this.window.findChild("localchannels");
        this.remoteChannelList = (WidgetList)this.window.findChild("remotechannels");
        this.refresh();
        this.listDirty = 0;
    }

    private void updatePublish(BlockPos pos, int index, String name) {
        this.sendServerCommandTyped(XNetMessages.INSTANCE, "router.updateName", TypedMap.builder().put(TileEntityRouter.PARAM_POS, (Object)pos).put(TileEntityRouter.PARAM_CHANNEL, (Object)index).put(TileEntityRouter.PARAM_NAME, (Object)name).build());
    }

    private void refresh() {
        fromServer_localChannels = null;
        fromServer_remoteChannels = null;
        this.needsRefresh = true;
        this.listDirty = 3;
        this.requestListsIfNeeded();
    }

    private boolean listsReady() {
        return fromServer_localChannels != null && fromServer_remoteChannels != null;
    }

    private void populateList() {
        if (!this.listsReady()) {
            return;
        }
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        this.localChannelList.removeChildren();
        this.localChannelList.rowheight(40);
        int sel = this.localChannelList.getSelected();
        for (ControllerChannelClientInfo channel : fromServer_localChannels) {
            this.localChannelList.children(new Widget[]{this.makeChannelLine(channel, true)});
        }
        this.localChannelList.selected(sel);
        this.remoteChannelList.removeChildren();
        this.remoteChannelList.rowheight(40);
        sel = this.remoteChannelList.getSelected();
        for (ControllerChannelClientInfo channel : fromServer_remoteChannels) {
            this.remoteChannelList.children(new Widget[]{this.makeChannelLine(channel, false)});
        }
        this.remoteChannelList.selected(sel);
    }

    private Panel makeChannelLine(ControllerChannelClientInfo channel, boolean local) {
        String name = channel.getChannelName();
        String publishedName = channel.getPublishedName();
        BlockPos controllerPos = channel.getPos();
        IChannelType type = channel.getChannelType();
        int index = channel.getIndex();
        Panel panel = (Panel)Widgets.positional().desiredHeight(30);
        Panel panel1 = (Panel)Widgets.horizontal((int)0, (int)0).hint(0, 0, 160, 13);
        int labelColor = -14531414;
        if (channel.isRemote()) {
            labelColor = -5631693;
        }
        panel1.children(new Widget[]{Widgets.label((String)"Ch").color(labelColor), Widgets.label((String)name), Widgets.label((String)">").color(labelColor)});
        if (channel.isRemote()) {
            panel1.children(new Widget[]{((ImageLabel)new ImageLabel().image(iconGuiElements, 48, 80)).desiredWidth(16)});
        }
        if (local) {
            TextField pubName = ((TextField)((TextField)new TextField().text(publishedName).desiredWidth(50)).desiredHeight(13)).event(newText -> this.updatePublish(controllerPos, index, newText));
            panel1.children(new Widget[]{pubName});
        } else {
            panel1.children(new Widget[]{Widgets.label((String)publishedName).color(-13369600)});
        }
        Panel panel2 = (Panel)((Panel)Widgets.horizontal((int)0, (int)0).hint(0, 13, 160, 13)).children(new Widget[]{Widgets.label((String)"Pos").color(labelColor), Widgets.label((String)BlockPosTools.toString((BlockPos)controllerPos))});
        Panel panel3 = (Panel)((Panel)Widgets.horizontal((int)0, (int)0).hint(0, 26, 160, 13)).children(new Widget[]{Widgets.label((String)"Index").color(labelColor), Widgets.label((String)(index + " (" + type.getName() + ")"))});
        panel.children(new Widget[]{panel1, panel2, panel3});
        return panel;
    }

    private void requestListsIfNeeded() {
        if (fromServer_localChannels != null && fromServer_remoteChannels != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            XNetMessages.INSTANCE.sendToServer((Object)new PacketGetLocalChannelsRouter(((TileEntityRouter)this.tileEntity).func_174877_v()));
            XNetMessages.INSTANCE.sendToServer((Object)new PacketGetRemoteChannelsRouter(((TileEntityRouter)this.tileEntity).func_174877_v()));
            this.listDirty = 10;
        }
    }

    protected void func_146976_a(float v, int x1, int x2) {
        this.requestListsIfNeeded();
        this.populateList();
        this.drawWindow();
    }
}

